/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.requests;

import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.requests.IRequestLogNewRecordListener;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.api.model.requests.RequestLogNewRecordEvent;

public class RequestLogNewRecordListener {
    private final IRequestLogNewRecordListener listenerCallback;
    private final IHttpConditionSet filterCondition;

    public RequestLogNewRecordListener(IRequestLogNewRecordListener iRequestLogNewRecordListener, IHttpConditionSet iHttpConditionSet) {
        this.listenerCallback = iRequestLogNewRecordListener;
        this.filterCondition = iHttpConditionSet;
    }

    void filterRecord(IRequestLogRecord iRequestLogRecord) {
        if (this.matchesRecord(iRequestLogRecord)) {
            this.listenerCallback.onNewRecord(new RequestLogNewRecordEvent(iRequestLogRecord));
        }
    }

    IRequestLogNewRecordListener getListener() {
        return this.listenerCallback;
    }

    private boolean matchesRecord(IRequestLogRecord iRequestLogRecord) {
        if (this.filterCondition != null) {
            return this.filterCondition.matchesAll(iRequestLogRecord);
        }
        return true;
    }
}

