/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.requests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

public class RequestLogEntity
implements HttpEntity {
    private byte[] content;
    private Header contentType;
    private Header contentEncoding;

    RequestLogEntity(byte[] byArray, Header header, Header header2) {
        this.content = byArray;
        this.contentType = this.copyHeader(header);
        this.contentEncoding = this.copyHeader(header2);
    }

    public byte[] getContentArray() {
        return this.content;
    }

    private Header copyHeader(Header header) {
        if (header == null) {
            return null;
        }
        return new BasicHeader(header.getName(), header.getValue());
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return this.content.length;
    }

    public Header getContentType() {
        return this.contentType;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return new ByteArrayInputStream(this.content);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        outputStream.write(this.content);
        outputStream.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public void consumeContent() throws IOException {
    }
}

