/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.requests;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectInfoEventArgs;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.model.requests.IRequestLogNewRecordListener;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.api.model.requests.IRequestOriginProxy;
import com.subgraph.vega.api.model.requests.IRequestOriginScanner;
import com.subgraph.vega.internal.model.conditions.HttpConditionSet;
import com.subgraph.vega.internal.model.requests.HttpMessageCloner;
import com.subgraph.vega.internal.model.requests.RequestLogEntityEnclosingRequest;
import com.subgraph.vega.internal.model.requests.RequestLogId;
import com.subgraph.vega.internal.model.requests.RequestLogNewRecordListener;
import com.subgraph.vega.internal.model.requests.RequestLogRecord;
import com.subgraph.vega.internal.model.requests.RequestLogResponse;
import com.subgraph.vega.internal.model.requests.RequestOrigin;
import com.subgraph.vega.internal.model.requests.RequestOriginProxy;
import com.subgraph.vega.internal.model.requests.RequestOriginScanner;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class RequestLog
implements IRequestLog {
    private final ObjectContainer database;
    private final RequestLogId requestLogId;
    private final HttpMessageCloner cloner;
    private final List<RequestLogNewRecordListener> newRecordListeners = new ArrayList<RequestLogNewRecordListener>();
    private final Object lock = new Object();

    public RequestLog(final ObjectContainer objectContainer) {
        this.database = objectContainer;
        this.requestLogId = this.getRequestLogId(objectContainer);
        this.cloner = new HttpMessageCloner(objectContainer);
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer((ObjectContainer)objectContainer);
        eventRegistry.activated().addListener((EventListener4)new EventListener4<ObjectInfoEventArgs>(){

            public void onEvent(Event4<ObjectInfoEventArgs> event4, ObjectInfoEventArgs objectInfoEventArgs) {
                Object object = objectInfoEventArgs.object();
                if (object instanceof RequestLogResponse) {
                    RequestLogResponse requestLogResponse = (RequestLogResponse)((Object)object);
                    requestLogResponse.setDatabase(objectContainer);
                } else if (object instanceof RequestLogEntityEnclosingRequest) {
                    RequestLogEntityEnclosingRequest requestLogEntityEnclosingRequest = (RequestLogEntityEnclosingRequest)((Object)object);
                    requestLogEntityEnclosingRequest.setDatabase(objectContainer);
                }
            }
        });
    }

    private RequestLogId getRequestLogId(ObjectContainer objectContainer) {
        ObjectSet objectSet = objectContainer.query(RequestLogId.class);
        if (objectSet.size() == 0) {
            RequestLogId requestLogId = new RequestLogId();
            objectContainer.store((Object)requestLogId);
            return requestLogId;
        }
        if (objectSet.size() == 1) {
            return (RequestLogId)objectSet.get(0);
        }
        throw new IllegalStateException("Database corrupted, found multiple RequestLogId instances");
    }

    public long allocateRequestId() {
        long l = this.requestLogId.allocateId();
        this.database.store((Object)this.requestLogId);
        return l;
    }

    public long getNextRequestId() {
        return this.requestLogId.getCurrentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addRequestResponse(IHttpResponse iHttpResponse) {
        if (iHttpResponse.getRequestId() != -1L) {
            return iHttpResponse.getRequestId();
        }
        long l = this.allocateRequestId();
        HttpRequest httpRequest = this.cloner.copyRequest(iHttpResponse.getOriginalRequest());
        HttpResponse httpResponse = this.cloner.copyResponse(iHttpResponse.getRawResponse());
        this.database.store((Object)httpRequest);
        this.database.store((Object)httpResponse);
        RequestLogRecord requestLogRecord = new RequestLogRecord(l, httpRequest, iHttpResponse.getRequestOrigin(), httpResponse, iHttpResponse.getHost(), iHttpResponse.getRequestMilliseconds(), iHttpResponse.getTags());
        Object object = this.lock;
        synchronized (object) {
            this.database.store((Object)requestLogRecord);
            this.filterNewRecord(requestLogRecord);
        }
        iHttpResponse.setRequestId(l);
        return l;
    }

    private void filterNewRecord(IRequestLogRecord iRequestLogRecord) {
        for (RequestLogNewRecordListener requestLogNewRecordListener : this.newRecordListeners) {
            requestLogNewRecordListener.filterRecord(iRequestLogRecord);
        }
    }

    public RequestLogRecord lookupRecord(final long l) {
        RequestLog requestLog = this;
        synchronized (requestLog) {
            ObjectSet objectSet;
            block5: {
                objectSet = this.database.query((Predicate)new Predicate<RequestLogRecord>(){
                    private static final long serialVersionUID = 1L;

                    public boolean match(RequestLogRecord requestLogRecord) {
                        return requestLogRecord.requestId == l;
                    }
                });
                if (objectSet.size() != 0) break block5;
                return null;
            }
            if (objectSet.size() == 1) {
                return (RequestLogRecord)objectSet.get(0);
            }
            throw new IllegalStateException("Database corrupted, found multiple RequestLogRecords for id == " + l);
        }
    }

    public List<IRequestLogRecord> getAllRecords() {
        if (!this.hasRecords()) {
            return Collections.emptyList();
        }
        Query query = this.database.query();
        query.constrain(IRequestLogRecord.class);
        return query.execute();
    }

    private boolean hasRecords() {
        Query query = this.database.query();
        query.constrain(IRequestLogRecord.class);
        return query.execute().hasNext();
    }

    public List<IRequestLogRecord> getRecordsByConditionSet(IHttpConditionSet iHttpConditionSet) {
        if (iHttpConditionSet instanceof HttpConditionSet) {
            return ((HttpConditionSet)iHttpConditionSet).filterRequestLog(this.database);
        }
        return Collections.emptyList();
    }

    public Iterator<IRequestLogRecord> getRecordIteratorByConditionSet(IHttpConditionSet iHttpConditionSet) {
        if (iHttpConditionSet instanceof HttpConditionSet) {
            ObjectSet<IRequestLogRecord> objectSet = ((HttpConditionSet)iHttpConditionSet).executeFilterQuery(this.database);
            return this.createIteratorForResult(objectSet);
        }
        List list = Collections.emptyList();
        return list.iterator();
    }

    private Iterator<IRequestLogRecord> createIteratorForResult(final ObjectSet<IRequestLogRecord> objectSet) {
        return new Iterator<IRequestLogRecord>(){

            @Override
            public boolean hasNext() {
                return objectSet.hasNext();
            }

            @Override
            public IRequestLogRecord next() {
                return (IRequestLogRecord)objectSet.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public IRequestOriginProxy getRequestOriginProxy(final InetAddress inetAddress, final int n) {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<IRequestOriginProxy>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IRequestOriginProxy iRequestOriginProxy) {
                return inetAddress.equals(iRequestOriginProxy.getInetAddress()) && n == iRequestOriginProxy.getPort();
            }
        });
        if (objectSet.size() == 0) {
            RequestOriginProxy requestOriginProxy = new RequestOriginProxy(inetAddress, n);
            this.database.store((Object)requestOriginProxy);
            return requestOriginProxy;
        }
        return (IRequestOriginProxy)objectSet.get(0);
    }

    public IRequestOriginScanner getRequestOriginScanner(final IScanInstance iScanInstance) {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<IRequestOriginScanner>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IRequestOriginScanner iRequestOriginScanner) {
                return iScanInstance.getScanId() == iRequestOriginScanner.getScanInstance().getScanId();
            }
        });
        if (objectSet.size() == 0) {
            RequestOriginScanner requestOriginScanner = new RequestOriginScanner(iScanInstance);
            this.database.store((Object)requestOriginScanner);
            return requestOriginScanner;
        }
        return (IRequestOriginScanner)objectSet.get(0);
    }

    public IRequestOrigin getRequestOriginRequestEditor() {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<IRequestOrigin>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IRequestOrigin iRequestOrigin) {
                return iRequestOrigin.getOrigin() == IRequestOrigin.Origin.ORIGIN_REQUEST_EDITOR;
            }
        });
        if (objectSet.size() == 0) {
            RequestOrigin requestOrigin = new RequestOrigin(IRequestOrigin.Origin.ORIGIN_REQUEST_EDITOR);
            this.database.store((Object)requestOrigin);
            return requestOrigin;
        }
        return (IRequestOrigin)objectSet.get(0);
    }

    public void addNewRecordListener(IRequestLogNewRecordListener iRequestLogNewRecordListener) {
        this.addNewRecordListener(iRequestLogNewRecordListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewRecordListener(IRequestLogNewRecordListener iRequestLogNewRecordListener, IHttpConditionSet iHttpConditionSet) {
        Object object = this.lock;
        synchronized (object) {
            this.newRecordListeners.add(new RequestLogNewRecordListener(iRequestLogNewRecordListener, iHttpConditionSet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNewRecordListener(IRequestLogNewRecordListener iRequestLogNewRecordListener) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<RequestLogNewRecordListener> iterator = this.newRecordListeners.iterator();
            while (iterator.hasNext()) {
                RequestLogNewRecordListener requestLogNewRecordListener = iterator.next();
                if (requestLogNewRecordListener.getListener() != iRequestLogNewRecordListener) continue;
                iterator.remove();
            }
        }
    }
}

