/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.identity;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.identity.IAuthMethodHttpMacro;
import com.subgraph.vega.api.model.identity.IAuthMethodNtlm;
import com.subgraph.vega.api.model.identity.IAuthMethodRfc2617;
import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.api.model.identity.IIdentityModel;
import com.subgraph.vega.api.model.identity.NewIdentityEvent;
import com.subgraph.vega.internal.model.identity.AuthMethodHttpMacro;
import com.subgraph.vega.internal.model.identity.AuthMethodNtlm;
import com.subgraph.vega.internal.model.identity.AuthMethodRfc2617;
import com.subgraph.vega.internal.model.identity.Identity;
import java.util.Collection;

public class IdentityModel
implements IIdentityModel {
    private final ObjectContainer database;
    private final EventListenerManager changeEventManager;

    public IdentityModel(ObjectContainer objectContainer) {
        this.database = objectContainer;
        this.changeEventManager = new EventListenerManager();
    }

    public Collection<IIdentity> getAllIdentities() {
        return this.database.query(IIdentity.class);
    }

    public IIdentity createIdentity() {
        return new Identity();
    }

    public IAuthMethodRfc2617 createAuthMethodRfc2617() {
        return new AuthMethodRfc2617();
    }

    public IAuthMethodNtlm createAuthMethodNtlm() {
        return new AuthMethodNtlm();
    }

    public IAuthMethodHttpMacro createAuthMethodHttpMacro() {
        return new AuthMethodHttpMacro();
    }

    public void store(IIdentity iIdentity) {
        this.database.store((Object)iIdentity);
        this.changeEventManager.fireEvent((IEvent)new NewIdentityEvent(iIdentity));
    }

    public boolean isIdentityStored(IIdentity iIdentity) {
        return this.database.ext().isStored((Object)iIdentity);
    }

    public IIdentity getIdentityByName(final String string) {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<IIdentity>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IIdentity iIdentity) {
                return string.equals(iIdentity.getName());
            }
        });
        if (objectSet.size() == 0) {
            return null;
        }
        return (IIdentity)objectSet.get(0);
    }

    public void addChangeListener(IEventHandler iEventHandler) {
        this.changeEventManager.addListener(iEventHandler);
    }

    public void removeChangeListener(IEventHandler iEventHandler) {
        this.changeEventManager.removeListener(iEventHandler);
    }
}

