/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions.match;

import com.subgraph.vega.api.model.conditions.match.IHttpConditionIntegerMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.internal.model.conditions.match.IHttpConditionMatchActionEx;

public abstract class IntegerMatchAction
implements IHttpConditionIntegerMatchAction,
IHttpConditionMatchActionEx {
    protected int integerValue;

    IntegerMatchAction() {
    }

    protected IntegerMatchAction(int n) {
        this.integerValue = n;
    }

    public IHttpConditionMatchAction.MatchActionArgumentType getArgumentType() {
        return IHttpConditionMatchAction.MatchActionArgumentType.ARGUMENT_INTEGER;
    }

    public void setInteger(int n) {
        this.integerValue = n;
    }

    public String getArgumentAsString() {
        return Integer.toString(this.integerValue);
    }

    public boolean setArgumentFromString(String string) {
        Integer n = this.stringToInteger(string);
        if (n == null) {
            return false;
        }
        this.integerValue = n;
        return true;
    }

    public boolean isValidArgumentString(String string) {
        return this.stringToInteger(string) != null;
    }

    private Integer stringToInteger(String string) {
        try {
            int n = Integer.parseInt(string.trim());
            return n < 0 ? null : Integer.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

