/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.internal.model.conditions.AbstractCondition;
import com.subgraph.vega.internal.model.conditions.ConditionType;
import com.subgraph.vega.internal.model.conditions.match.IntegerMatchActionSet;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class ConditionResponseStatusCode
extends AbstractCondition {
    private static transient IHttpConditionType conditionType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpConditionType getConditionType() {
        Class<ConditionResponseStatusCode> clazz = ConditionResponseStatusCode.class;
        synchronized (ConditionResponseStatusCode.class) {
            if (conditionType == null) {
                conditionType = ConditionResponseStatusCode.createType();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return conditionType;
        }
    }

    private static IHttpConditionType createType() {
        return new ConditionType("response status code", new IntegerMatchActionSet()){

            public IHttpCondition createConditionInstance(IHttpConditionMatchAction iHttpConditionMatchAction) {
                return new ConditionResponseStatusCode(iHttpConditionMatchAction, null);
            }
        };
    }

    private ConditionResponseStatusCode(IHttpConditionMatchAction iHttpConditionMatchAction) {
        super(iHttpConditionMatchAction);
    }

    public boolean matches(HttpRequest httpRequest) {
        return false;
    }

    public boolean matches(HttpResponse httpResponse) {
        if (httpResponse == null) {
            return false;
        }
        return this.matchesInteger(httpResponse.getStatusLine().getStatusCode());
    }

    public boolean matches(HttpRequest httpRequest, HttpResponse httpResponse) {
        return this.matches(httpResponse);
    }

    public IHttpConditionType getType() {
        return ConditionResponseStatusCode.getConditionType();
    }

    @Override
    public Constraint filterRequestLogQuery(Query query) {
        return this.constrainQuery(query.descend("responseCode"));
    }

    /* synthetic */ ConditionResponseStatusCode(IHttpConditionMatchAction iHttpConditionMatchAction, ConditionResponseStatusCode conditionResponseStatusCode) {
        this(iHttpConditionMatchAction);
    }
}

