/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.internal.model.conditions.AbstractCondition;
import com.subgraph.vega.internal.model.conditions.ConditionType;
import com.subgraph.vega.internal.model.conditions.match.IntegerMatchActionSet;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class ConditionRequestId
extends AbstractCondition {
    private static transient IHttpConditionType conditionType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpConditionType getConditionType() {
        Class<ConditionRequestId> clazz = ConditionRequestId.class;
        synchronized (ConditionRequestId.class) {
            if (conditionType == null) {
                conditionType = ConditionRequestId.createType();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return conditionType;
        }
    }

    private static IHttpConditionType createType() {
        return new ConditionType("request id", new IntegerMatchActionSet(), true){

            public IHttpCondition createConditionInstance(IHttpConditionMatchAction iHttpConditionMatchAction) {
                return new ConditionRequestId(iHttpConditionMatchAction, null);
            }
        };
    }

    private ConditionRequestId(IHttpConditionMatchAction iHttpConditionMatchAction) {
        super(iHttpConditionMatchAction);
    }

    public IHttpConditionType getType() {
        return ConditionRequestId.getConditionType();
    }

    @Override
    public boolean matches(IRequestLogRecord iRequestLogRecord) {
        return this.matchesInteger((int)iRequestLogRecord.getRequestId());
    }

    public boolean matches(HttpRequest httpRequest) {
        return false;
    }

    public boolean matches(HttpResponse httpResponse) {
        return false;
    }

    public boolean matches(HttpRequest httpRequest, HttpResponse httpResponse) {
        return false;
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public Constraint filterRequestLogQuery(Query query) {
        return this.constrainQuery(query.descend("requestId"));
    }

    /* synthetic */ ConditionRequestId(IHttpConditionMatchAction iHttpConditionMatchAction, ConditionRequestId conditionRequestId) {
        this(iHttpConditionMatchAction);
    }
}

