/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.internal.model.conditions.AbstractCondition;
import com.subgraph.vega.internal.model.conditions.ConditionType;
import com.subgraph.vega.internal.model.conditions.match.StringMatchActionSet;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class ConditionHostname
extends AbstractCondition {
    private static transient IHttpConditionType conditionType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpConditionType getConditionType() {
        Class<ConditionHostname> clazz = ConditionHostname.class;
        synchronized (ConditionHostname.class) {
            if (conditionType == null) {
                conditionType = ConditionHostname.createType();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return conditionType;
        }
    }

    private static IHttpConditionType createType() {
        return new ConditionType("hostname", new StringMatchActionSet()){

            public IHttpCondition createConditionInstance(IHttpConditionMatchAction iHttpConditionMatchAction) {
                return new ConditionHostname(iHttpConditionMatchAction, null);
            }
        };
    }

    private ConditionHostname(IHttpConditionMatchAction iHttpConditionMatchAction) {
        super(iHttpConditionMatchAction);
    }

    public boolean matches(HttpRequest httpRequest) {
        String string = this.getRequestHostname(httpRequest);
        if (string == null) {
            return false;
        }
        return this.matchesString(string);
    }

    private String getRequestHostname(HttpRequest httpRequest) {
        Header header = httpRequest.getFirstHeader("Host");
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public boolean matches(HttpResponse httpResponse) {
        return false;
    }

    public boolean matches(HttpRequest httpRequest, HttpResponse httpResponse) {
        return this.matches(httpRequest);
    }

    public IHttpConditionType getType() {
        return ConditionHostname.getConditionType();
    }

    @Override
    public Constraint filterRequestLogQuery(Query query) {
        return this.constrainQuery(query.descend("hostname"));
    }

    /* synthetic */ ConditionHostname(IHttpConditionMatchAction iHttpConditionMatchAction, ConditionHostname conditionHostname) {
        this(iHttpConditionMatchAction);
    }
}

