/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.alerts;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectInfoEventArgs;
import com.db4o.query.Predicate;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.alerts.ActiveScanInstanceEvent;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanAlertRepository;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.alerts.NewScanInstanceEvent;
import com.subgraph.vega.api.model.alerts.RemoveScanAlertsEvent;
import com.subgraph.vega.api.model.alerts.RemoveScanInstanceEvent;
import com.subgraph.vega.api.xml.IXmlRepository;
import com.subgraph.vega.internal.model.alerts.ScanAlertFactory;
import com.subgraph.vega.internal.model.alerts.ScanInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;

public class ScanAlertRepository
implements IScanAlertRepository {
    private static final Logger logger = Logger.getLogger("alerts");
    private final ObjectContainer database;
    private final Object scanInstanceLock = new Object();
    private final ScanAlertFactory alertFactory;
    private final EventListenerManager scanInstanceEventManager;
    private final List<IScanInstance> activeScanInstanceList;

    public ScanAlertRepository(ObjectContainer objectContainer, IXmlRepository iXmlRepository) {
        this.database = objectContainer;
        this.alertFactory = new ScanAlertFactory(iXmlRepository);
        this.scanInstanceEventManager = new EventListenerManager();
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer((ObjectContainer)this.database);
        eventRegistry.activated().addListener((EventListener4)new EventListener4<ObjectInfoEventArgs>(){

            public void onEvent(Event4<ObjectInfoEventArgs> event4, ObjectInfoEventArgs objectInfoEventArgs) {
                Object object = objectInfoEventArgs.object();
                if (object instanceof ScanInstance) {
                    ScanInstance scanInstance = (ScanInstance)object;
                    scanInstance.setTransientState(ScanAlertRepository.this.database, ScanAlertRepository.this, ScanAlertRepository.this.alertFactory);
                    int n = scanInstance.getScanStatus();
                    if (n != 0 && n != 4 && n != 5) {
                        scanInstance.updateScanStatus(5);
                    }
                }
            }
        });
        this.getProxyScanInstance();
        this.activeScanInstanceList = new ArrayList<IScanInstance>();
    }

    void fireRemoveEventsEvent(IScanInstance iScanInstance, Collection<IScanAlert> collection) {
        this.scanInstanceEventManager.fireEvent((IEvent)new RemoveScanAlertsEvent(iScanInstance, collection));
    }

    public List<IScanInstance> addActiveScanInstanceListener(IEventHandler iEventHandler) {
        this.scanInstanceEventManager.addListener(iEventHandler);
        return this.getAllActiveScanInstances();
    }

    public void removeActiveScanInstanceListener(IEventHandler iEventHandler) {
        this.scanInstanceEventManager.removeListener(iEventHandler);
    }

    public synchronized void addActiveScanInstance(IScanInstance iScanInstance) {
        this.activeScanInstanceList.add(iScanInstance);
        this.scanInstanceEventManager.fireEvent((IEvent)new ActiveScanInstanceEvent(iScanInstance));
    }

    public synchronized void removeActiveScanInstance(IScanInstance iScanInstance) {
        this.activeScanInstanceList.remove(iScanInstance);
    }

    public synchronized List<IScanInstance> getAllActiveScanInstances() {
        return new ArrayList<IScanInstance>(this.activeScanInstanceList);
    }

    public List<IScanInstance> getAllScanInstances() {
        return this.database.query(IScanInstance.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IScanInstance createNewScanInstance() {
        Object object = this.scanInstanceLock;
        synchronized (object) {
            long l = this.allocateNewScanId();
            IScanInstance iScanInstance = this.createScanInstanceForScanId(l);
            this.scanInstanceEventManager.fireEvent((IEvent)new NewScanInstanceEvent(iScanInstance));
            return iScanInstance;
        }
    }

    private IScanInstance createScanInstanceForScanId(long l) {
        ScanInstance scanInstance = new ScanInstance(l);
        scanInstance.setTransientState(this.database, this, this.alertFactory);
        this.database.store((Object)scanInstance);
        return scanInstance;
    }

    public synchronized IScanInstance getScanInstanceByScanId(final long l) {
        ObjectSet objectSet = this.database.query((Predicate)new Predicate<IScanInstance>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IScanInstance iScanInstance) {
                return iScanInstance.getScanId() == l;
            }
        });
        if (objectSet.size() == 0) {
            return null;
        }
        if (objectSet.size() > 1) {
            logger.warning("Multiple scan instances for scanId = " + l);
        }
        return (IScanInstance)objectSet.get(0);
    }

    public synchronized IScanInstance getProxyScanInstance() {
        IScanInstance iScanInstance = this.getScanInstanceByScanId(-1L);
        if (iScanInstance != null) {
            return iScanInstance;
        }
        return this.createScanInstanceForScanId(-1L);
    }

    private long allocateNewScanId() {
        int n = 0;
        Random random = new Random();
        do {
            long l;
            if (this.getScanInstanceByScanId(l = (long)(random.nextInt(999999) + 1)) != null) continue;
            return l;
        } while (++n <= 10);
        throw new IllegalStateException("Unable to generate unique random scan id");
    }

    public Collection<IScanAlert> getAlertsByRequestId(final long l) {
        return this.database.query((Predicate)new Predicate<IScanAlert>(){
            private static final long serialVersionUID = 1L;

            public boolean match(IScanAlert iScanAlert) {
                return iScanAlert.getRequestId() == l;
            }
        });
    }

    public synchronized void removeScanInstance(IScanInstance iScanInstance) {
        if (iScanInstance.getScanId() == -1L) {
            throw new IllegalArgumentException("Cannot remove scan instance for proxy alerts");
        }
        if (iScanInstance.isActive()) {
            throw new IllegalArgumentException("Cannot remove active scan instance");
        }
        this.scanInstanceEventManager.fireEvent((IEvent)new RemoveScanInstanceEvent(iScanInstance));
        if (this.activeScanInstanceList.contains(iScanInstance)) {
            this.activeScanInstanceList.remove(iScanInstance);
        }
        iScanInstance.deleteScanInstance();
        this.database.delete((Object)iScanInstance);
    }
}

