/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.alerts;

import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.xml.IXmlRepository;
import com.subgraph.vega.internal.model.alerts.ScanAlert;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScanAlertFactory {
    private final Logger logger = Logger.getLogger("alerts");
    private final IXmlRepository xmlRepository;

    ScanAlertFactory(IXmlRepository iXmlRepository) {
        this.xmlRepository = iXmlRepository;
    }

    ScanAlert createAlert(String string, String string2, IScanInstance iScanInstance, long l) {
        Document document = this.xmlRepository.getDocument("alerts/" + string2 + ".xml");
        if (document == null) {
            document = this.xmlRepository.getDocument("alerts/default.xml");
        }
        if (document == null) {
            this.logger.warning("Could not find XML alert description named " + string2);
            return null;
        }
        Element element = this.getAlertElement(document, string2);
        if (element == null) {
            return null;
        }
        IScanAlert.Severity severity = this.parseSeverity(element);
        String string3 = this.parseTitle(element);
        return new ScanAlert(string, string2, string3, severity, iScanInstance, l);
    }

    private IScanAlert.Severity parseSeverity(Element element) {
        NodeList nodeList = element.getElementsByTagName("severity");
        if (nodeList.getLength() == 0 || nodeList.item(0).getNodeType() != 1) {
            return IScanAlert.Severity.UNKNOWN;
        }
        return this.processSeverityElement((Element)nodeList.item(0));
    }

    private IScanAlert.Severity processSeverityElement(Element element) {
        String string = this.getTextForElement(element);
        if (string == null) {
            return IScanAlert.Severity.UNKNOWN;
        }
        if (string.equalsIgnoreCase("high")) {
            return IScanAlert.Severity.HIGH;
        }
        if (string.equalsIgnoreCase("medium")) {
            return IScanAlert.Severity.MEDIUM;
        }
        if (string.equalsIgnoreCase("low")) {
            return IScanAlert.Severity.LOW;
        }
        if (string.equalsIgnoreCase("info")) {
            return IScanAlert.Severity.INFO;
        }
        return IScanAlert.Severity.UNKNOWN;
    }

    private String parseTitle(Element element) {
        NodeList nodeList = element.getElementsByTagName("title");
        if (nodeList.getLength() == 0 || nodeList.item(0).getNodeType() != 1) {
            return null;
        }
        Element element2 = (Element)nodeList.item(0);
        return this.getTextForElement(element2);
    }

    private String getTextForElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 3) {
                return node.getNodeValue();
            }
            ++n;
        }
        return null;
    }

    private Element getAlertElement(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName("alert");
        int n = nodeList.getLength();
        if (n == 0) {
            this.logger.warning("No alert node found in XML for description " + string);
            return null;
        }
        if (n > 1) {
            this.logger.warning("Multiple alert entries found in XML for description " + string + ", ignoring extras");
        }
        if (nodeList.item(0).getNodeType() != 1) {
            return null;
        }
        return (Element)nodeList.item(0);
    }
}

