/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.alerts;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.ActivatableArrayList;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanAlertHighlight;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.internal.model.ModelProperties;
import com.subgraph.vega.internal.model.alerts.ScanAlertHighlight;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ScanAlert
implements IScanAlert,
Activatable {
    private final String name;
    private final IScanAlert.Severity severity;
    private final String title;
    private final String key;
    private final IScanInstance scanInstance;
    private final long requestId;
    private final List<IScanAlertHighlight> alertHighlights;
    private String templateName = "main";
    private String resource;
    private final ModelProperties properties;
    private transient Activator activator;
    private String discretionaryHostname;

    ScanAlert(String string, String string2, String string3, IScanAlert.Severity severity, IScanInstance iScanInstance, long l) {
        this.key = string;
        this.name = string2;
        this.title = string3;
        this.severity = severity;
        this.properties = new ModelProperties();
        this.scanInstance = iScanInstance;
        this.requestId = l;
        this.alertHighlights = new ActivatableArrayList();
    }

    public String getName() {
        this.activate(ActivationPurpose.READ);
        return this.name;
    }

    public IScanAlert.Severity getSeverity() {
        this.activate(ActivationPurpose.READ);
        return this.severity;
    }

    public String getTitle() {
        this.activate(ActivationPurpose.READ);
        return this.title;
    }

    public String getDiscretionaryHostname() {
        this.activate(ActivationPurpose.READ);
        return this.discretionaryHostname;
    }

    public void setDiscretionaryHostname(String string) {
        this.activate(ActivationPurpose.READ);
        this.discretionaryHostname = string;
        this.activate(ActivationPurpose.WRITE);
    }

    public void setResource(String string) {
        this.activate(ActivationPurpose.READ);
        this.resource = string;
        this.activate(ActivationPurpose.WRITE);
    }

    public void setTemplateName(String string) {
        this.activate(ActivationPurpose.READ);
        this.templateName = string;
        this.activate(ActivationPurpose.WRITE);
    }

    public void setProperty(String string, Object object) {
        this.activate(ActivationPurpose.READ);
        if (string.equals("resource") && object instanceof String) {
            this.resource = (String)object;
            this.activate(ActivationPurpose.WRITE);
        }
        this.properties.setProperty(string, object);
    }

    public void setStringProperty(String string, String string2) {
        this.activate(ActivationPurpose.READ);
        this.properties.setStringProperty(string, string2);
    }

    public void setIntegerProperty(String string, int n) {
        this.activate(ActivationPurpose.READ);
        this.properties.setIntegerProperty(string, n);
    }

    public Object getProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getProperty(string);
    }

    public String getStringProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getStringProperty(string);
    }

    public Integer getIntegerProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getIntegerProperty(string);
    }

    public List<String> propertyKeys() {
        this.activate(ActivationPurpose.READ);
        return this.properties.propertyKeys();
    }

    public String getTemplateName() {
        this.activate(ActivationPurpose.READ);
        return this.templateName;
    }

    public String getResource() {
        this.activate(ActivationPurpose.READ);
        return this.resource;
    }

    public String getKey() {
        this.activate(ActivationPurpose.READ);
        return this.key;
    }

    public boolean hasAssociatedRequest() {
        this.activate(ActivationPurpose.READ);
        return this.requestId != -1L;
    }

    public IScanInstance getScanInstance() {
        this.activate(ActivationPurpose.READ);
        return this.scanInstance;
    }

    public long getScanId() {
        this.activate(ActivationPurpose.READ);
        return this.scanInstance.getScanId();
    }

    public long getRequestId() {
        this.activate(ActivationPurpose.READ);
        return this.requestId;
    }

    public void addStringMatchHighlight(String string) {
        this.activate(ActivationPurpose.READ);
        this.alertHighlights.add(new ScanAlertHighlight(string, false, false));
        this.activate(ActivationPurpose.WRITE);
    }

    public void addRegexHighlight(String string) {
        this.activate(ActivationPurpose.READ);
        this.alertHighlights.add(new ScanAlertHighlight(string, true, true));
        this.activate(ActivationPurpose.WRITE);
    }

    public void addRegexCaseInsensitiveHighlight(String string) {
        this.activate(ActivationPurpose.READ);
        this.alertHighlights.add(new ScanAlertHighlight(string, true, false));
        this.activate(ActivationPurpose.WRITE);
    }

    public Collection<IScanAlertHighlight> getHighlights() {
        this.activate(ActivationPurpose.READ);
        return Collections.unmodifiableCollection(new ArrayList<IScanAlertHighlight>(this.alertHighlights));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScanAlert scanAlert = (ScanAlert)object;
        if (this.key == null ? scanAlert.key != null : !this.key.equals(scanAlert.key)) {
            return false;
        }
        if (this.name == null ? scanAlert.name != null : !this.name.equals(scanAlert.name)) {
            return false;
        }
        if (this.requestId != scanAlert.requestId) {
            return false;
        }
        if (this.scanInstance == null ? scanAlert.scanInstance != null : !this.scanInstance.equals(scanAlert.scanInstance)) {
            return false;
        }
        if (this.severity != scanAlert.severity) {
            return false;
        }
        return !(this.title == null ? scanAlert.title != null : !this.title.equals(scanAlert.title));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (int)(this.requestId ^ this.requestId >>> 32);
        n = 31 * n + (this.scanInstance == null ? 0 : this.scanInstance.hashCode());
        n = 31 * n + (this.severity == null ? 0 : this.severity.hashCode());
        n = 31 * n + (this.title == null ? 0 : this.title.hashCode());
        return n;
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

