/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.ActivatableHashMap;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.model.IModelProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModelProperties
implements IModelProperties,
Activatable {
    private final Map<String, Object> propertyMap = new ActivatableHashMap();
    private transient Activator activator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, Object object) {
        this.activate(ActivationPurpose.READ);
        Map<String, Object> map = this.propertyMap;
        synchronized (map) {
            this.propertyMap.put(string, object);
        }
    }

    public void setStringProperty(String string, String string2) {
        this.setProperty(string, string2);
    }

    public void setIntegerProperty(String string, int n) {
        this.setProperty(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        this.activate(ActivationPurpose.READ);
        Map<String, Object> map = this.propertyMap;
        synchronized (map) {
            return this.propertyMap.get(string);
        }
    }

    public String getStringProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("Property '" + string + "' exists but it is not a String");
    }

    public Integer getIntegerProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new IllegalArgumentException("Property '" + string + "' exists but it is not an Integer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> propertyKeys() {
        this.activate(ActivationPurpose.READ);
        Map<String, Object> map = this.propertyMap;
        synchronized (map) {
            return new ArrayList<String>(this.propertyMap.keySet());
        }
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

