/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.scope;

import com.subgraph.vega.ui.scanner.scope.RemovableItemWidget;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;

public class ExcludeWidget
extends RemovableItemWidget {
    public ExcludeWidget(Composite composite, StructuredViewer structuredViewer) {
        super(composite, "Exclude (URL or pattern)", structuredViewer);
    }

    @Override
    Object[] getTableInput() {
        if (this.currentScope == null) {
            return new Object[0];
        }
        ArrayList arrayList = new ArrayList(this.currentScope.getExclusionURIs());
        arrayList.addAll(this.currentScope.getExclusionPatterns());
        return arrayList.toArray();
    }

    @Override
    boolean verifyText(String string) {
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    @Override
    boolean handleInput(String string) {
        if (this.currentScope == null) {
            return false;
        }
        this.currentScope.addExclusionPattern(string);
        return true;
    }

    @Override
    boolean handleRemoveElement(Object object) {
        if (this.currentScope == null) {
            return false;
        }
        if (object instanceof String) {
            this.currentScope.removeExclusionPattern((String)object);
            return true;
        }
        if (object instanceof URI) {
            this.currentScope.removeExclusionURI((URI)object);
            return true;
        }
        return false;
    }
}

