/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.scope;

import com.subgraph.vega.api.util.UriTools;
import com.subgraph.vega.ui.scanner.scope.RemovableItemWidget;
import java.net.URI;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;

public class BasePathWidget
extends RemovableItemWidget {
    public BasePathWidget(Composite composite, StructuredViewer structuredViewer) {
        super(composite, "Base Paths", structuredViewer);
    }

    @Override
    boolean verifyText(String string) {
        return UriTools.isTextValidURI((String)string);
    }

    @Override
    boolean handleInput(String string) {
        URI uRI = UriTools.getURIFromText((String)string);
        if (uRI == null || this.currentScope == null) {
            return false;
        }
        this.currentScope.addScopeURI(uRI);
        return true;
    }

    @Override
    boolean handleRemoveElement(Object object) {
        if (this.currentScope == null || !(object instanceof URI)) {
            return false;
        }
        this.currentScope.removeScopeURI((URI)object, false);
        return true;
    }

    @Override
    Object[] getTableInput() {
        if (this.currentScope == null) {
            return new Object[0];
        }
        return this.currentScope.getScopeURIs().toArray();
    }
}

