/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.info;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.xml.IXmlRepository;
import com.subgraph.vega.ui.scanner.Activator;
import freemarker.cache.TemplateLoader;
import freemarker.ext.dom.NodeModel;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.RequestLine;
import org.apache.http.client.utils.URLEncodedUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AlertRenderer {
    private final Logger logger = Logger.getLogger((String)"alert-render");
    private Configuration configuration;
    private final String imageURL;
    private final String bulletPointURL;
    private final String bannerPatternURL;
    private final String bannerLogoURL;
    private final String titlePatternURL;
    private final String redArrowURL;
    private final String sectionGradientURL;
    private final String linkArrowURL;
    private final Map<String, Document> alertDocumentCache = new HashMap<String, Document>();
    private IRequestLog requestLog;

    AlertRenderer(TemplateLoader templateLoader) {
        this.imageURL = this.findImage("icons/vega_logo.png");
        this.bulletPointURL = this.findImage("icons/doubleArrow.png");
        this.bannerPatternURL = this.findImage("icons/bannerPattern.png");
        this.bannerLogoURL = this.findImage("icons/bannerLogo.png");
        this.titlePatternURL = this.findImage("icons/titlePattern.png");
        this.redArrowURL = this.findImage("icons/redArrow.png");
        this.sectionGradientURL = this.findImage("icons/sectionGradient.png");
        this.linkArrowURL = this.findImage("icons/linkArrow.png");
        this.configuration = new Configuration();
        this.configuration.setTemplateLoader(templateLoader);
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        IWorkspace iWorkspace = Activator.getDefault().getModel().addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    AlertRenderer.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    AlertRenderer.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    AlertRenderer.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        });
        if (iWorkspace != null) {
            this.requestLog = iWorkspace.getRequestLog();
        }
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.requestLog = workspaceOpenEvent.getWorkspace().getRequestLog();
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.requestLog = null;
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.requestLog = workspaceResetEvent.getWorkspace().getRequestLog();
    }

    public String render(IScanAlert iScanAlert) {
        Document document;
        Template template;
        HashMap<String, Object> hashMap;
        int n;
        block20: {
            n = Activator.getDefault().getPreferenceStore().getInt("MaxAlertString");
            hashMap = new HashMap<String, Object>();
            template = this.configuration.getTemplate("main.ftl");
            document = this.getAlertDocument(iScanAlert.getName());
            if (document != null) break block20;
            return "";
        }
        try {
            Object object;
            String string;
            NodeModel nodeModel = NodeModel.wrap((Node)document);
            hashMap.put("doc", nodeModel);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            Object object2 = iScanAlert.propertyKeys().iterator();
            while (object2.hasNext()) {
                string = (String)object2.next();
                object = iScanAlert.getProperty(string);
                if (object instanceof String) {
                    String string2 = (String)object;
                    if (string2.length() > n) {
                        string2 = String.valueOf(string2.substring(0, n)) + "...";
                    }
                    hashMap2.put(string, string2);
                    continue;
                }
                hashMap2.put(string, iScanAlert.getProperty(string));
            }
            string = this.severityToString(iScanAlert.getSeverity());
            if (string != null) {
                hashMap2.put("severity", string);
            }
            if ((object2 = this.severityToSeverityCSSClass(iScanAlert.getSeverity())) != null) {
                hashMap2.put("severityCSS", object2);
            }
            if (this.imageURL != null) {
                hashMap2.put("imageURL", this.imageURL);
            }
            if (this.bulletPointURL != null) {
                hashMap2.put("bulletPointURL", this.bulletPointURL);
            }
            if (this.bannerPatternURL != null) {
                hashMap2.put("bannerPatternURL", this.bannerPatternURL);
            }
            if (this.bannerLogoURL != null) {
                hashMap2.put("bannerLogoURL", this.bannerLogoURL);
            }
            if (this.titlePatternURL != null) {
                hashMap2.put("titlePatternURL", this.titlePatternURL);
            }
            if (this.redArrowURL != null) {
                hashMap2.put("redArrowURL", this.redArrowURL);
            }
            if (this.redArrowURL != null) {
                hashMap2.put("sectionGradientURL", this.sectionGradientURL);
            }
            if (this.linkArrowURL != null) {
                hashMap2.put("linkArrowURL", this.linkArrowURL);
            }
            if (iScanAlert.getRequestId() >= 0L && this.requestLog != null && (object = this.requestLog.lookupRecord(iScanAlert.getRequestId())) != null) {
                if (object.getRequest() instanceof HttpEntityEnclosingRequest) {
                    hashMap2.put("requestText", this.renderEntityEnclosingRequest((HttpEntityEnclosingRequest)object.getRequest()));
                } else {
                    hashMap2.put("requestText", this.renderBasicRequest(object.getRequest()));
                }
                hashMap2.put("requestId", Long.toString(iScanAlert.getRequestId()));
            }
            hashMap.put("vars", hashMap2);
            object = new StringWriter();
            template.process(hashMap, (Writer)object);
            ((StringWriter)object).flush();
            return ((StringWriter)object).toString();
        }
        catch (IOException iOException) {
            return "I/O error reading alert template file alerts/" + iScanAlert.getName() + ".xml :<br><br>" + iOException.getMessage();
        }
        catch (TemplateException templateException) {
            return "Error processing alert template file alerts/" + iScanAlert.getName() + ".xml :<br><br>" + templateException.getMessage();
        }
    }

    private String renderEntityEnclosingRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        HttpEntity httpEntity = httpEntityEnclosingRequest.getEntity();
        if (httpEntity == null || !URLEncodedUtils.isEncoded((HttpEntity)httpEntity)) {
            return this.renderBasicRequest((HttpRequest)httpEntityEnclosingRequest);
        }
        try {
            List list = URLEncodedUtils.parse((HttpEntity)httpEntity);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.renderBasicRequest((HttpRequest)httpEntityEnclosingRequest));
            stringBuilder.append("\n[");
            for (NameValuePair nameValuePair : list) {
                stringBuilder.append(nameValuePair.getName());
                if (nameValuePair.getValue() != null) {
                    stringBuilder.append("=");
                    stringBuilder.append(nameValuePair.getValue());
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return this.renderBasicRequest((HttpRequest)httpEntityEnclosingRequest);
        }
    }

    private String renderBasicRequest(HttpRequest httpRequest) {
        RequestLine requestLine = httpRequest.getRequestLine();
        return String.valueOf(requestLine.getMethod()) + " " + requestLine.getUri();
    }

    private Document getAlertDocument(String string) {
        if (this.alertDocumentCache.containsKey(string)) {
            return this.alertDocumentCache.get(string);
        }
        IXmlRepository iXmlRepository = Activator.getDefault().getXmlRepository();
        if (iXmlRepository == null) {
            this.logger.warn("Could not render alert because xml repository service is not available");
            return null;
        }
        Document document = iXmlRepository.getDocument("alerts/" + string + ".xml");
        if (document == null) {
            document = iXmlRepository.getDocument("alerts/default.xml");
        }
        if (document == null) {
            this.logger.warn("Could not load XML data for alert named '" + string + "'");
            return null;
        }
        this.alertDocumentCache.put(string, document);
        return document;
    }

    private String findImage(String string) {
        Bundle bundle = Activator.getDefault().getBundle();
        Path path = new Path(string);
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            URL uRL2 = FileLocator.toFileURL((URL)uRL);
            return uRL2.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private String severityToString(IScanAlert.Severity severity) {
        switch (severity) {
            case HIGH: {
                return "High";
            }
            case MEDIUM: {
                return "Medium";
            }
            case LOW: {
                return "Low";
            }
            case INFO: {
                return "Info";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return null;
    }

    private String severityToSeverityCSSClass(IScanAlert.Severity severity) {
        switch (severity) {
            case HIGH: {
                return "highrisk";
            }
            case MEDIUM: {
                return "medrisk";
            }
            case LOW: {
                return "lowrisk";
            }
            case INFO: {
                return "inforisk";
            }
            case UNKNOWN: {
                return "unknownrisk";
            }
        }
        return null;
    }
}

