/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.dialogs;

import com.subgraph.vega.api.scanner.modules.IScannerModuleRegistry;
import com.subgraph.vega.ui.scanner.Activator;
import com.subgraph.vega.ui.util.modules.ModuleRegistryCheckStateProvider;
import com.subgraph.vega.ui.util.modules.ModuleRegistryContentProvider;
import com.subgraph.vega.ui.util.modules.ModuleRegistryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ScanConfigDialog
extends Dialog {
    private IScannerModuleRegistry registry;
    private CheckboxTreeViewer viewer;
    private Text cookieString;
    private Table exclusionsTable;

    public ScanConfigDialog(Shell shell) {
        super(shell);
        this.setShellStyle(16);
    }

    protected Control createDialogArea(Composite composite) {
        this.registry = Activator.getDefault().getIScannerModuleRegistry();
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(composite2, 2048);
        this.createTabItemModules(tabFolder);
        this.createTabItemAuthentication(tabFolder);
        this.createTabItemCookieString(tabFolder);
        this.createTabItemExclusions(tabFolder);
        return composite2;
    }

    private void createTabItemModules(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Modules");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("Select Modules");
        this.viewer = new CheckboxTreeViewer(composite, 2818);
        ModuleRegistryCheckStateProvider moduleRegistryCheckStateProvider = new ModuleRegistryCheckStateProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ModuleRegistryContentProvider(moduleRegistryCheckStateProvider));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ModuleRegistryLabelProvider());
        this.viewer.setCheckStateProvider((ICheckStateProvider)moduleRegistryCheckStateProvider);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setInput((Object)this.registry);
        this.viewer.addCheckStateListener((ICheckStateListener)moduleRegistryCheckStateProvider);
        tabItem.setControl((Control)composite);
    }

    private void createTabItemAuthentication(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Authentication");
        GridLayout gridLayout = new GridLayout();
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(768);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Basic Authentication");
        label.setLayoutData((Object)gridData2);
        Label label2 = new Label(composite, 0);
        label2.setText("Username:");
        Text text = new Text(composite, 2052);
        text.setLayoutData((Object)gridData);
        Label label3 = new Label(composite, 0);
        label3.setText("Password:");
        Text text2 = new Text(composite, 2048);
        text2.setLayoutData((Object)gridData);
        Label label4 = new Label(composite, 0);
        label4.setText("Realm:");
        Text text3 = new Text(composite, 2048);
        text3.setLayoutData((Object)gridData);
        Label label5 = new Label(composite, 0);
        label5.setText("Domain");
        Text text4 = new Text(composite, 2048);
        text4.setLayoutData((Object)gridData);
        Label label6 = new Label(composite, 0);
        label6.setText("NTLM Authentication");
        label6.setLayoutData((Object)gridData2);
        Label label7 = new Label(composite, 0);
        label7.setText("Username:");
        Text text5 = new Text(composite, 2048);
        text5.setLayoutData((Object)gridData);
        Label label8 = new Label(composite, 0);
        label8.setText("Password:");
        Text text6 = new Text(composite, 2048);
        text6.setLayoutData((Object)gridData);
        tabItem.setControl((Control)composite);
    }

    private void createTabItemCookieString(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Cookie String");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        GridData gridData = new GridData(768);
        gridData.widthHint = 140;
        gridData.heightHint = 60;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 2048);
        label.setText("Cookie string:");
        this.cookieString = new Text(composite, 2626);
        this.cookieString.setLayoutData((Object)gridData);
        tabItem.setControl((Control)composite);
    }

    private void createTabItemExclusions(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Exclusions");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Set scan exclusion patterns:");
        final Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setMessage("regular expression");
        final Button button = new Button(composite, 8);
        button.setText("Add exclusion");
        this.exclusionsTable = new Table(composite, 2050);
        this.exclusionsTable.setLayoutData((Object)new GridData(768));
        Button button2 = new Button(composite, 8);
        button2.setText("Remove selected exclusion(s)");
        button2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ScanConfigDialog.this.exclusionsTable.remove(ScanConfigDialog.this.exclusionsTable.getSelectionIndices());
            }
        });
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == button && text.getText() != null) {
                    TableItem tableItem;
                    TableItem[] tableItemArray;
                    TableItem[] tableItemArray2 = tableItemArray = ScanConfigDialog.this.exclusionsTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        tableItem = tableItemArray2[n2];
                        if (text.getText().equals(tableItem.getText())) {
                            return;
                        }
                        ++n2;
                    }
                    tableItem = new TableItem(ScanConfigDialog.this.exclusionsTable, 0);
                    tableItem.setText(text.getText());
                }
            }
        });
        tabItem.setControl((Control)composite);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createSaveButton(composite, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Button createSaveButton(Composite composite, boolean bl) {
        Shell shell;
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setText("Save");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScanConfigDialog.this.okPressed();
            }
        });
        if (bl && (shell = composite.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Scan Configuration");
    }
}

