/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.dashboard;

import com.subgraph.vega.ui.scanner.dashboard.CrawlerProgressPane;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CrawlerPane
extends Composite {
    private final CrawlerProgressPane progressPane;
    private final Label pathLabel;
    private final Label crawlLabel;
    private volatile boolean changed;
    private boolean isScannerPaused;
    private int scannerStatus;
    private String scannerPath;
    private int crawlerTotal;
    private int crawlerCompleted;
    private double crawlerPercent;

    CrawlerPane(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new GridLayout());
        this.progressPane = new CrawlerProgressPane(this, composite.getBackground());
        GridData gridData = new GridData(0x1000000, 1024, true, true);
        gridData.widthHint = 300;
        this.progressPane.setLayoutData(gridData);
        this.pathLabel = new Label((Composite)this, 0x1000000);
        this.pathLabel.setFont(JFaceResources.getBannerFont());
        gridData = new GridData(0x1000000, 0x1000000, true, true);
        gridData.widthHint = 400;
        this.pathLabel.setLayoutData((Object)gridData);
        this.pathLabel.setBackground(composite.getBackground());
        this.crawlLabel = new Label((Composite)this, 0x1000000);
        this.crawlLabel.setFont(JFaceResources.getBannerFont());
        gridData = new GridData(0x1000000, 0x1000000, true, true);
        gridData.widthHint = 300;
        this.crawlLabel.setLayoutData((Object)gridData);
        this.crawlLabel.setBackground(composite.getBackground());
    }

    void setScannerPaused(boolean bl) {
        this.isScannerPaused = bl;
    }

    void renderChanges() {
        if (!this.changed || this.isDisposed()) {
            return;
        }
        Display display = this.getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                CrawlerPane.this.renderProgress();
                CrawlerPane.this.renderLabel();
            }
        });
    }

    synchronized void updateCrawlerProgress(int n, String string, int n2, int n3) {
        if (n == this.scannerStatus && this.scannerPath == string && n2 == this.crawlerTotal && n3 == this.crawlerCompleted) {
            return;
        }
        this.scannerStatus = n;
        this.scannerPath = string;
        this.crawlerTotal = n2;
        this.crawlerCompleted = n3;
        this.crawlerPercent = this.crawlerTotal == 0 ? 0.0 : (double)this.crawlerCompleted / (double)this.crawlerTotal * 100.0;
        this.changed = true;
    }

    private void renderProgress() {
        switch (this.scannerStatus) {
            case 0: 
            case 1: {
                this.progressPane.setLabelText("Probing server..");
            }
            case 2: 
            case 3: {
                this.progressPane.setProgressBarValue((int)this.crawlerPercent);
                break;
            }
            case 5: {
                this.progressPane.setLabelText("Scanner canceled.");
                break;
            }
            case 4: {
                this.progressPane.setLabelText("Scanner completed.");
            }
        }
    }

    private void renderLabel() {
        if (this.crawlLabel.isDisposed()) {
            return;
        }
        if (this.crawlerPercent < 0.01) {
            this.crawlLabel.setText("");
        }
        if (this.scannerPath != null) {
            this.pathLabel.setText(this.scannerPath);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.crawlerCompleted);
        stringBuilder.append(" out of ");
        stringBuilder.append(this.crawlerTotal);
        stringBuilder.append(" scanned (");
        if (this.isScannerPaused) {
            stringBuilder.append("Scanner Paused");
        } else {
            stringBuilder.append(String.format("%.1f%%", this.crawlerPercent));
        }
        stringBuilder.append(")");
        this.crawlLabel.setText(stringBuilder.toString());
    }
}

