/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.commands;

import com.subgraph.vega.api.scanner.IScan;
import com.subgraph.vega.ui.scanner.alerts.ScanAlertView;
import com.subgraph.vega.ui.util.dialogs.ErrorDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractScanHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        ScanAlertView scanAlertView = this.getScanAlertView(executionEvent);
        if (scanAlertView == null) {
            return null;
        }
        IScan iScan = scanAlertView.getSelection();
        if (iScan != null) {
            this.runCommand(executionEvent, iScan);
        }
        return null;
    }

    private ScanAlertView getScanAlertView(ExecutionEvent executionEvent) {
        try {
            return (ScanAlertView)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)executionEvent).getActivePage().showView("com.subgraph.vega.views.alert");
        }
        catch (PartInitException partInitException) {
            Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)executionEvent).getShell();
            ErrorDialog.displayExceptionError((Shell)shell, (Exception)((Object)partInitException));
            return null;
        }
    }

    protected abstract void runCommand(ExecutionEvent var1, IScan var2);
}

