/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts.tree;

import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertSeverityNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AlertTitleNode
implements IAlertTreeNode {
    private static final String ALERT_ITEM = "icons/alert_item.png";
    private final AlertSeverityNode parentNode;
    private final String title;
    private final List<IScanAlert> alerts;

    AlertTitleNode(AlertSeverityNode alertSeverityNode, String string) {
        this.parentNode = alertSeverityNode;
        this.title = string;
        this.alerts = new ArrayList<IScanAlert>();
    }

    @Override
    public String getLabel() {
        if (this.alerts.size() == 1) {
            return String.valueOf(this.title) + " (" + this.alerts.get(0).getResource() + ")";
        }
        return this.title;
    }

    @Override
    public String getKey() {
        return this.title;
    }

    @Override
    public void remove() {
        this.alerts.clear();
        this.parentNode.removeNode(this.getKey());
    }

    @Override
    public void addAlert(IScanAlert iScanAlert) {
        this.alerts.add(iScanAlert);
    }

    @Override
    public void removeAlert(IScanAlert iScanAlert) {
        this.alerts.remove(iScanAlert);
    }

    @Override
    public Collection<IScanAlert> getAlerts() {
        return Collections.unmodifiableList(new ArrayList<IScanAlert>(this.alerts));
    }

    @Override
    public boolean hasChildren() {
        return this.alerts.size() > 1;
    }

    @Override
    public int getAlertCount() {
        return this.alerts.size();
    }

    @Override
    public Object[] getChildren() {
        if (this.alerts.size() > 1) {
            return this.alerts.toArray();
        }
        return new Object[0];
    }

    public IScanAlert getFirstAlert() {
        if (this.alerts.isEmpty()) {
            return null;
        }
        return this.alerts.get(0);
    }

    @Override
    public String getImage() {
        return ALERT_ITEM;
    }

    @Override
    public IScanInstance getScanInstance() {
        return this.parentNode.getScanInstance();
    }
}

