/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts.tree;

import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.ui.scanner.alerts.tree.AbstractAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertHostNode;
import java.text.SimpleDateFormat;
import org.apache.http.HttpHost;

public class AlertScanNode
extends AbstractAlertTreeNode {
    private static final String SCAN_IMAGE = "icons/scanner.png";
    private static final String PROXY_IMAGE = "icons/proxy.png";
    private static final String NO_HOSTNAME = "No Hostname";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private final IWorkspace workspace;
    private final long scanId;
    private IScanInstance scanInstance;

    AlertScanNode(AbstractAlertTreeNode abstractAlertTreeNode, long l, IWorkspace iWorkspace) {
        super(abstractAlertTreeNode);
        this.workspace = iWorkspace;
        this.scanId = l;
    }

    void setScanInstance(IScanInstance iScanInstance) {
        this.scanInstance = iScanInstance;
    }

    @Override
    public IScanInstance getScanInstance() {
        return this.scanInstance;
    }

    @Override
    public String getLabel() {
        if (this.scanId == -1L) {
            return "Proxy";
        }
        if (this.scanInstance == null) {
            return "Scan [id: #" + Long.toString(this.scanId) + "]  ";
        }
        return this.renderScanInstance();
    }

    private String renderScanInstance() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scanInstance.getStartTime() != null) {
            stringBuilder.append(this.dateFormat.format(this.scanInstance.getStartTime()));
        }
        if (this.scanInstance.isScanPaused()) {
            stringBuilder.append(" [Scan Paused] ");
            return stringBuilder.toString();
        }
        stringBuilder.append(" [");
        switch (this.scanInstance.getScanStatus()) {
            case 1: {
                stringBuilder.append("Probing Server");
                break;
            }
            case 2: {
                stringBuilder.append("Starting");
                break;
            }
            case 3: {
                stringBuilder.append("Auditing");
                break;
            }
            case 5: {
                stringBuilder.append("Cancelled");
                break;
            }
            case 4: {
                stringBuilder.append("Completed");
            }
        }
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    @Override
    protected AbstractAlertTreeNode createNodeForAlert(IScanAlert iScanAlert) {
        return new AlertHostNode(this, this.createKeyForAlert(iScanAlert));
    }

    @Override
    public String getImage() {
        if (this.scanId == -1L) {
            return PROXY_IMAGE;
        }
        return SCAN_IMAGE;
    }

    @Override
    protected String createKeyForAlert(IScanAlert iScanAlert) {
        if (!iScanAlert.hasAssociatedRequest()) {
            if (iScanAlert.getDiscretionaryHostname() != null) {
                return iScanAlert.getDiscretionaryHostname();
            }
            return NO_HOSTNAME;
        }
        IRequestLogRecord iRequestLogRecord = this.workspace.getRequestLog().lookupRecord(iScanAlert.getRequestId());
        if (iRequestLogRecord == null) {
            return NO_HOSTNAME;
        }
        HttpHost httpHost = iRequestLogRecord.getHttpHost();
        if (httpHost == null) {
            return NO_HOSTNAME;
        }
        return httpHost.toString();
    }

    public long getScanId() {
        return this.scanId;
    }

    @Override
    public String getKey() {
        return Long.toString(this.scanId);
    }
}

