/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts.tree;

import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractAlertTreeNode
implements IAlertTreeNode {
    protected final AbstractAlertTreeNode parentNode;
    protected final Map<String, IAlertTreeNode> nodeMap = new HashMap<String, IAlertTreeNode>();

    protected AbstractAlertTreeNode(AbstractAlertTreeNode abstractAlertTreeNode) {
        this.parentNode = abstractAlertTreeNode;
    }

    @Override
    public void addAlert(IScanAlert iScanAlert) {
        IAlertTreeNode iAlertTreeNode = this.getNodeForAlert(iScanAlert);
        if (iAlertTreeNode != null) {
            iAlertTreeNode.addAlert(iScanAlert);
        }
    }

    @Override
    public void removeAlert(IScanAlert iScanAlert) {
        String string = this.createKeyForAlert(iScanAlert);
        IAlertTreeNode[] iAlertTreeNodeArray = this.getChildren();
        int n = iAlertTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAlertTreeNode iAlertTreeNode = iAlertTreeNodeArray[n2];
            if (iAlertTreeNode.getKey().equals(string)) {
                iAlertTreeNode.removeAlert(iScanAlert);
            }
            if (iAlertTreeNode.getAlertCount() == 0) {
                this.removeNode(string);
            }
            ++n2;
        }
    }

    @Override
    public void remove() {
        IAlertTreeNode[] iAlertTreeNodeArray = this.getChildren();
        int n = iAlertTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAlertTreeNode iAlertTreeNode = iAlertTreeNodeArray[n2];
            iAlertTreeNode.remove();
            ++n2;
        }
        this.parentNode.removeNode(this.getKey());
    }

    @Override
    public Collection<IScanAlert> getAlerts() {
        ArrayList<IScanAlert> arrayList = new ArrayList<IScanAlert>();
        IAlertTreeNode[] iAlertTreeNodeArray = this.getChildren();
        int n = iAlertTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAlertTreeNode iAlertTreeNode = iAlertTreeNodeArray[n2];
            arrayList.addAll(iAlertTreeNode.getAlerts());
            ++n2;
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public boolean hasChildren() {
        return this.nodeMap.size() > 0;
    }

    @Override
    public int getAlertCount() {
        int n = 0;
        for (IAlertTreeNode iAlertTreeNode : this.nodeMap.values()) {
            n += iAlertTreeNode.getAlertCount();
        }
        return n;
    }

    public synchronized IAlertTreeNode[] getChildren() {
        return this.nodeMap.values().toArray(new IAlertTreeNode[0]);
    }

    public synchronized void removeNode(String string) {
        this.nodeMap.remove(string);
    }

    @Override
    public String getImage() {
        return null;
    }

    @Override
    public IScanInstance getScanInstance() {
        if (this.parentNode != null) {
            return this.parentNode.getScanInstance();
        }
        return null;
    }

    protected synchronized IAlertTreeNode getNodeForAlert(IScanAlert iScanAlert) {
        String string = this.createKeyForAlert(iScanAlert);
        if (string == null) {
            return null;
        }
        if (!this.nodeMap.containsKey(string)) {
            this.nodeMap.put(string, this.createNodeForAlert(iScanAlert));
        }
        return this.nodeMap.get(string);
    }

    protected abstract IAlertTreeNode createNodeForAlert(IScanAlert var1);

    protected abstract String createKeyForAlert(IScanAlert var1);
}

