/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.alerts.ScanPauseStateChangedEvent;
import com.subgraph.vega.api.model.alerts.ScanStatusChangeEvent;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertTitleNode;
import com.subgraph.vega.ui.scanner.commands.PauseStateSourceProvider;
import com.subgraph.vega.ui.scanner.commands.ScannerStateSourceProvider;
import com.subgraph.vega.ui.scanner.info.ScanInfoView;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class SelectionTracker
implements ISelectionChangedListener {
    private final Logger logger = Logger.getLogger("scan-alert-view");
    private final IWorkbenchPage page;
    private final IEventHandler scanEventHandler;
    private IScanInstance selectedScanInstance;

    public SelectionTracker(IWorkbenchPage iWorkbenchPage) {
        this.page = iWorkbenchPage;
        this.scanEventHandler = this.createScanEventHandler();
    }

    private IEventHandler createScanEventHandler() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof ScanPauseStateChangedEvent || iEvent instanceof ScanStatusChangeEvent) {
                    SelectionTracker.this.updateSourceProviders(SelectionTracker.this.selectedScanInstance);
                }
            }
        };
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.handleSelection((IStructuredSelection)selectionChangedEvent.getSelection());
    }

    private void handleSelection(IStructuredSelection iStructuredSelection) {
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IAlertTreeNode) {
            this.setSelectedScanInstance(((IAlertTreeNode)object).getScanInstance());
            if (object instanceof AlertTitleNode) {
                this.activateInfoView();
            }
        } else if (object instanceof IScanAlert) {
            this.setSelectedScanInstance(((IScanAlert)object).getScanInstance());
            this.activateInfoView();
        } else {
            this.setSelectedScanInstance(null);
        }
    }

    private void activateInfoView() {
        try {
            this.page.showView(ScanInfoView.ID, null, 2);
        }
        catch (PartInitException partInitException) {
            this.logger.log(Level.WARNING, "Failed to open Scan Info view", partInitException);
        }
    }

    private void setSelectedScanInstance(IScanInstance iScanInstance) {
        if (this.selectedScanInstance != null) {
            this.selectedScanInstance.removeScanEventListener(this.scanEventHandler);
        }
        this.selectedScanInstance = iScanInstance;
        if (this.selectedScanInstance != null) {
            this.selectedScanInstance.addScanEventListenerAndPopulate(this.scanEventHandler);
        }
        this.updateSourceProviders(iScanInstance);
    }

    private void updateSourceProviders(IScanInstance iScanInstance) {
        ISourceProviderService iSourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        this.updatePauseStateSourceProvider((PauseStateSourceProvider)iSourceProviderService.getSourceProvider("vega.pauseState"), iScanInstance);
        this.updateScannerStateSourceProvider((ScannerStateSourceProvider)iSourceProviderService.getSourceProvider("vega.scanSelectionState"), iScanInstance);
    }

    private void updatePauseStateSourceProvider(PauseStateSourceProvider pauseStateSourceProvider, IScanInstance iScanInstance) {
        if (pauseStateSourceProvider != null) {
            pauseStateSourceProvider.setSelectedScan(iScanInstance);
        }
    }

    private void updateScannerStateSourceProvider(ScannerStateSourceProvider scannerStateSourceProvider, IScanInstance iScanInstance) {
        if (scannerStateSourceProvider != null) {
            if (iScanInstance != null) {
                scannerStateSourceProvider.setScanSelectionIsActive(iScanInstance.isActive());
            } else {
                scannerStateSourceProvider.setScanSelectionIsActive(false);
            }
        }
    }
}

