/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.scope.ActiveScopeChangedEvent;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.ui.scanner.alerts.CurrentScopeFilter;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ScopeTracker {
    private final StructuredViewer viewer;
    private final IEventHandler scopeChangeListener;
    private IWorkspace currentWorkspace;
    private ViewerFilter activeScopeFilter;
    private boolean filterEnabled;

    ScopeTracker(StructuredViewer structuredViewer) {
        this.viewer = structuredViewer;
        this.scopeChangeListener = this.createScopeChangeListener();
    }

    private IEventHandler createScopeChangeListener() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof ActiveScopeChangedEvent) {
                    ScopeTracker.this.changeActiveScope(((ActiveScopeChangedEvent)iEvent).getActiveScope());
                }
            }
        };
    }

    private void changeActiveScope(ITargetScope iTargetScope) {
        if (this.currentWorkspace == null) {
            return;
        }
        if (this.activeScopeFilter != null) {
            this.viewer.removeFilter(this.activeScopeFilter);
            this.activeScopeFilter = null;
        }
        if (this.filterEnabled) {
            this.activeScopeFilter = new CurrentScopeFilter(this.currentWorkspace, iTargetScope);
            this.viewer.addFilter(this.activeScopeFilter);
        }
    }

    public void workspaceChanged(IWorkspace iWorkspace) {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.getTargetScopeManager().removeActiveScopeChangeListener(this.scopeChangeListener);
        }
        this.currentWorkspace = iWorkspace;
        if (iWorkspace != null) {
            ITargetScope iTargetScope = iWorkspace.getTargetScopeManager().addActiveScopeChangeListener(this.scopeChangeListener);
            this.changeActiveScope(iTargetScope);
        }
    }

    public void setFilterByScopeEnabled(boolean bl) {
        this.filterEnabled = bl;
        ITargetScope iTargetScope = this.currentWorkspace.getTargetScopeManager().getActiveScope();
        this.changeActiveScope(iTargetScope);
    }
}

