/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts;

import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.util.UriTools;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertHostNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertScanNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertSeverityNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertTitleNode;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CurrentScopeFilter
extends ViewerFilter {
    private final IWorkspace workspace;
    private final ITargetScope currentScope;

    public CurrentScopeFilter(IWorkspace iWorkspace, ITargetScope iTargetScope) {
        this.workspace = iWorkspace;
        this.currentScope = iTargetScope;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        return this.selectElement(object2);
    }

    private boolean selectElement(Object object) {
        if (object instanceof AlertScanNode) {
            return this.selectAlertScanNode((AlertScanNode)object);
        }
        if (object instanceof AlertHostNode) {
            return this.selectAlertHostNode((AlertHostNode)object);
        }
        if (object instanceof AlertSeverityNode) {
            return this.selectAlertSeverityNode((AlertSeverityNode)object);
        }
        if (object instanceof AlertTitleNode) {
            return this.selectAlertTitleNode((AlertTitleNode)object);
        }
        if (object instanceof IScanAlert) {
            return this.selectScanAlert((IScanAlert)object);
        }
        return false;
    }

    private boolean selectAlertScanNode(AlertScanNode alertScanNode) {
        IAlertTreeNode[] iAlertTreeNodeArray = alertScanNode.getChildren();
        int n = iAlertTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAlertTreeNode iAlertTreeNode = iAlertTreeNodeArray[n2];
            if (this.selectElement(iAlertTreeNode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean selectAlertHostNode(AlertHostNode alertHostNode) {
        IAlertTreeNode[] iAlertTreeNodeArray = alertHostNode.getChildren();
        int n = iAlertTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAlertTreeNode iAlertTreeNode = iAlertTreeNodeArray[n2];
            if (this.selectElement(iAlertTreeNode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean selectAlertSeverityNode(AlertSeverityNode alertSeverityNode) {
        IAlertTreeNode[] iAlertTreeNodeArray = alertSeverityNode.getChildren();
        int n = iAlertTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAlertTreeNode iAlertTreeNode = iAlertTreeNodeArray[n2];
            if (this.selectElement(iAlertTreeNode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean selectAlertTitleNode(AlertTitleNode alertTitleNode) {
        if (alertTitleNode.hasChildren()) {
            Object[] objectArray = alertTitleNode.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (this.selectElement(object)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return this.selectScanAlert(alertTitleNode.getFirstAlert());
    }

    private boolean selectScanAlert(IScanAlert iScanAlert) {
        IRequestLogRecord iRequestLogRecord = this.alertToRecord(iScanAlert);
        if (iRequestLogRecord == null) {
            return false;
        }
        HttpHost httpHost = iRequestLogRecord.getHttpHost();
        String string = this.recordToUriPath(iRequestLogRecord);
        if (httpHost == null || string == null) {
            return false;
        }
        return this.currentScope.filter(httpHost, string);
    }

    private IRequestLogRecord alertToRecord(IScanAlert iScanAlert) {
        if (iScanAlert == null) {
            return null;
        }
        return this.workspace.getRequestLog().lookupRecord(iScanAlert.getRequestId());
    }

    private String recordToUriPath(IRequestLogRecord iRequestLogRecord) {
        HttpRequest httpRequest = iRequestLogRecord.getRequest();
        if (httpRequest == null) {
            return null;
        }
        return UriTools.removeUnicodeEscapes((String)httpRequest.getRequestLine().getUri());
    }
}

