/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.scanner.alerts;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.alerts.ActiveScanInstanceEvent;
import com.subgraph.vega.api.model.alerts.IScanAlert;
import com.subgraph.vega.api.model.alerts.IScanInstance;
import com.subgraph.vega.api.model.alerts.NewScanAlertEvent;
import com.subgraph.vega.api.model.alerts.RemoveScanAlertsEvent;
import com.subgraph.vega.api.model.alerts.RemoveScanInstanceEvent;
import com.subgraph.vega.api.model.alerts.ScanStatusChangeEvent;
import com.subgraph.vega.ui.scanner.alerts.IAlertTreeNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertScanNode;
import com.subgraph.vega.ui.scanner.alerts.tree.AlertTree;
import com.subgraph.vega.ui.util.images.ImageCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class AlertTreeContentProvider
implements ITreeContentProvider,
IEventHandler {
    private static final long BLINK_INTERVAL = 1000L;
    private final ImageCache imageCache = new ImageCache("com.subgraph.vega.ui.scanner");
    private final Timer blinkTimer = new Timer();
    private final Map<Long, Integer> lastStatusMap = new TreeMap<Long, Integer>();
    private AlertTree tree;
    private TreeViewer viewer;
    private IWorkspace workspace;
    private IScanInstance proxyInstance;
    private List<AlertScanNode> activeList = new ArrayList<AlertScanNode>();
    private boolean activeBlinkState;

    public void dispose() {
        this.imageCache.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputChanged(Viewer viewer, Object object, Object object2) {
        AlertTreeContentProvider alertTreeContentProvider = this;
        synchronized (alertTreeContentProvider) {
            this.viewer = (TreeViewer)viewer;
            if (object2 instanceof IWorkspace) {
                this.setNewModelAndViewer((IWorkspace)object2);
            } else {
                this.setNullModel();
            }
        }
    }

    private void setNullModel() {
        this.tree = null;
        this.workspace = null;
        this.lastStatusMap.clear();
        this.activeList.clear();
    }

    private void setNewModelAndViewer(IWorkspace iWorkspace) {
        if (iWorkspace != this.workspace) {
            if (this.workspace != null) {
                this.workspace.getScanAlertRepository().removeActiveScanInstanceListener((IEventHandler)this);
            }
            if (this.proxyInstance != null) {
                this.proxyInstance.removeScanEventListener((IEventHandler)this);
            }
            this.lastStatusMap.clear();
            this.activeList.clear();
            this.workspace = iWorkspace;
            if (iWorkspace == null) {
                return;
            }
            this.tree = new AlertTree(this.workspace);
            for (IScanInstance iScanInstance : this.workspace.getScanAlertRepository().getAllScanInstances()) {
                if (iScanInstance.getScanStatus() == 0) continue;
                this.tree.addScan(iScanInstance);
                for (IScanAlert iScanAlert : iScanInstance.getAllAlerts()) {
                    this.tree.addAlert(iScanAlert);
                }
            }
            for (IScanInstance iScanInstance : this.workspace.getScanAlertRepository().addActiveScanInstanceListener((IEventHandler)this)) {
                this.addActiveScan(iScanInstance);
            }
            this.proxyInstance = this.workspace.getScanAlertRepository().getProxyScanInstance();
            this.lastStatusMap.put(this.proxyInstance.getScanId(), -1);
            this.proxyInstance.addScanEventListenerAndPopulate((IEventHandler)this);
        }
    }

    public Object[] getElements(Object object) {
        if (this.tree != null) {
            return this.tree.getChildren();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IAlertTreeNode) {
            return ((IAlertTreeNode)object).getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof IAlertTreeNode) {
            return ((IAlertTreeNode)object).hasChildren();
        }
        return false;
    }

    public void removeAlert(IScanAlert iScanAlert) {
        if (this.tree != null) {
            this.tree.removeAlert(iScanAlert);
            this.refreshViewer();
        }
    }

    private void handleNewScanAlert(NewScanAlertEvent newScanAlertEvent) {
        if (this.tree != null) {
            this.tree.addAlert(newScanAlertEvent.getAlert());
            this.refreshViewer();
        }
    }

    private void handleRemoveScanAlerts(RemoveScanAlertsEvent removeScanAlertsEvent) {
        if (this.tree != null) {
            this.tree.removeAlerts(removeScanAlertsEvent.getRemovedEvents());
            this.refreshViewer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActiveScanInstance(final ActiveScanInstanceEvent activeScanInstanceEvent) {
        AlertTreeContentProvider alertTreeContentProvider = this;
        synchronized (alertTreeContentProvider) {
            if (this.viewer != null) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AlertTreeContentProvider.this.tree != null && activeScanInstanceEvent.getScanInstance() != null) {
                            AlertTreeContentProvider.this.addActiveScan(activeScanInstanceEvent.getScanInstance());
                        }
                    }
                });
            }
        }
    }

    private void handleRemoveScanInstance(RemoveScanInstanceEvent removeScanInstanceEvent) {
        if (this.tree != null && !removeScanInstanceEvent.getScanInstance().isActive()) {
            this.tree.removeScan(removeScanInstanceEvent.getScanInstance());
            this.refreshViewer();
            AlertScanNode alertScanNode = this.chooseScanNode();
            if (alertScanNode != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)alertScanNode));
            }
        }
    }

    private AlertScanNode chooseScanNode() {
        if (this.tree == null) {
            return null;
        }
        List<AlertScanNode> list = this.tree.getScanNodes();
        if (list.size() == 0) {
            return null;
        }
        for (AlertScanNode alertScanNode : list) {
            if (!alertScanNode.getScanInstance().isActive()) continue;
            return alertScanNode;
        }
        return list.get(0);
    }

    private void addActiveScan(IScanInstance iScanInstance) {
        if (iScanInstance != null) {
            this.lastStatusMap.put(iScanInstance.getScanId(), -1);
            iScanInstance.addScanEventListenerAndPopulate((IEventHandler)this);
            AlertScanNode alertScanNode = this.tree.addScan(iScanInstance);
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)alertScanNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleScanStatusChange(ScanStatusChangeEvent scanStatusChangeEvent) {
        int n;
        int n2 = this.lastStatusMap.get(scanStatusChangeEvent.getScanInstance().getScanId());
        if (n2 != (n = scanStatusChangeEvent.getStatus())) {
            long l = scanStatusChangeEvent.getScanInstance().getScanId();
            this.lastStatusMap.put(l, n);
            if (l != -1L) {
                if (scanStatusChangeEvent.getScanInstance().isActive()) {
                    AlertScanNode alertScanNode = this.tree.getScanNode(scanStatusChangeEvent.getScanInstance().getScanId());
                    AlertTreeContentProvider alertTreeContentProvider = this;
                    synchronized (alertTreeContentProvider) {
                        if (!this.activeList.contains(alertScanNode)) {
                            this.activeList.add(alertScanNode);
                            if (this.activeList.size() == 1) {
                                this.blinkTimer.scheduleAtFixedRate(this.createBlinkTask(), 0L, 1000L);
                            }
                        }
                    }
                }
                if (scanStatusChangeEvent.getScanInstance().isComplete()) {
                    AlertTreeContentProvider alertTreeContentProvider = this;
                    synchronized (alertTreeContentProvider) {
                        this.activeList.remove(this.tree.getScanNode(l));
                    }
                }
            }
            this.refreshViewer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshViewer() {
        AlertTreeContentProvider alertTreeContentProvider = this;
        synchronized (alertTreeContentProvider) {
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AlertTreeContentProvider.this.viewer.refresh();
                    }
                });
            }
        }
    }

    public void handleEvent(IEvent iEvent) {
        if (iEvent instanceof NewScanAlertEvent) {
            this.handleNewScanAlert((NewScanAlertEvent)iEvent);
        } else if (iEvent instanceof RemoveScanAlertsEvent) {
            this.handleRemoveScanAlerts((RemoveScanAlertsEvent)iEvent);
        } else if (iEvent instanceof ActiveScanInstanceEvent) {
            this.handleActiveScanInstance((ActiveScanInstanceEvent)iEvent);
        } else if (iEvent instanceof RemoveScanInstanceEvent) {
            this.handleRemoveScanInstance((RemoveScanInstanceEvent)iEvent);
        } else if (iEvent instanceof ScanStatusChangeEvent) {
            this.handleScanStatusChange((ScanStatusChangeEvent)iEvent);
        }
    }

    private TimerTask createBlinkTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AlertTreeContentProvider alertTreeContentProvider = AlertTreeContentProvider.this;
                synchronized (alertTreeContentProvider) {
                    if (AlertTreeContentProvider.this.activeList.size() != 0) {
                        AlertTreeContentProvider.this.activeBlinkState = !AlertTreeContentProvider.this.activeBlinkState;
                    } else {
                        AlertTreeContentProvider.this.activeBlinkState = false;
                        this.cancel();
                    }
                    AlertTreeContentProvider.this.updateScanNodes();
                }
            }
        };
    }

    private void updateScanNodes() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (AlertScanNode alertScanNode : AlertTreeContentProvider.this.activeList) {
                        AlertTreeContentProvider.this.viewer.update((Object)alertScanNode, null);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlinkStateActive() {
        AlertTreeContentProvider alertTreeContentProvider = this;
        synchronized (alertTreeContentProvider) {
            return this.activeBlinkState;
        }
    }
}

