/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.identity.identityview.tree;

import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.ui.identity.identityview.tree.AuthenticationTreeNode;
import com.subgraph.vega.ui.identity.identityview.tree.DictionaryTreeNode;
import com.subgraph.vega.ui.identity.identityview.tree.IIdentityTreeNode;
import com.subgraph.vega.ui.identity.identityview.tree.ScanExclusionsTreeNode;
import java.util.ArrayList;
import java.util.List;

public class IdentityTreeNode
implements IIdentityTreeNode {
    private static final String IMAGE_PATH = "icons/identity.png";
    private final IIdentity identity;
    private final List<IIdentityTreeNode> childrenList = new ArrayList<IIdentityTreeNode>();

    public IdentityTreeNode(IIdentity iIdentity) {
        this.identity = iIdentity;
        this.childrenList.add(new DictionaryTreeNode(iIdentity));
        this.childrenList.add(new AuthenticationTreeNode(iIdentity));
        this.childrenList.add(new ScanExclusionsTreeNode(iIdentity));
    }

    @Override
    public String getText() {
        return this.identity.getName();
    }

    @Override
    public String getImagePath() {
        return IMAGE_PATH;
    }

    @Override
    public boolean hasChildren() {
        return this.childrenList.size() > 0;
    }

    @Override
    public Object[] getChildren() {
        return this.childrenList.toArray();
    }
}

