/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.identity.identityview.tree;

import com.subgraph.vega.api.model.identity.IAuthMethod;
import com.subgraph.vega.api.model.identity.IIdentity;
import com.subgraph.vega.ui.identity.identityview.tree.AuthMethodHttpMacroTreeNode;
import com.subgraph.vega.ui.identity.identityview.tree.AuthMethodNtlmTreeNode;
import com.subgraph.vega.ui.identity.identityview.tree.AuthMethodRfc2617TreeNode;
import com.subgraph.vega.ui.identity.identityview.tree.IIdentityTreeNode;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationTreeNode
implements IIdentityTreeNode {
    private static final String IMAGE_PATH = "icons/authentication.png";
    private final IIdentity identity;
    private IAuthMethod authMethod;
    private List<IIdentityTreeNode> childrenList;

    public AuthenticationTreeNode(IIdentity iIdentity) {
        this.identity = iIdentity;
    }

    @Override
    public String getText() {
        return "Authentication";
    }

    @Override
    public String getImagePath() {
        return IMAGE_PATH;
    }

    @Override
    public boolean hasChildren() {
        IAuthMethod iAuthMethod = this.identity.getAuthMethod();
        if (iAuthMethod != this.authMethod) {
            if (this.childrenList == null) {
                this.childrenList = new ArrayList<IIdentityTreeNode>();
            } else {
                this.childrenList.clear();
            }
            this.authMethod = iAuthMethod;
            switch (this.authMethod.getType()) {
                case AUTH_METHOD_RFC2617: {
                    this.childrenList.add(new AuthMethodRfc2617TreeNode(this.authMethod));
                    break;
                }
                case AUTH_METHOD_NTLM: {
                    this.childrenList.add(new AuthMethodNtlmTreeNode(this.authMethod));
                    break;
                }
                case AUTH_METHOD_HTTP_MACRO: {
                    this.childrenList.add(new AuthMethodHttpMacroTreeNode(this.authMethod));
                }
            }
        }
        return this.childrenList != null && this.childrenList.size() != 0;
    }

    @Override
    public Object[] getChildren() {
        return this.childrenList.toArray();
    }
}

