/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests.connection;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.http.HttpHost;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class SocksModeClientConnectionOperator
extends DefaultClientConnectionOperator {
    private final boolean isSocksMode = System.getProperty("socksEnabled") != null;

    public SocksModeClientConnectionOperator(SchemeRegistry schemeRegistry) {
        super(schemeRegistry);
    }

    public void openConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, InetAddress inetAddress, HttpContext httpContext, HttpParams httpParams) throws IOException {
        Object object;
        Serializable serializable;
        if (!this.isSocksMode) {
            super.openConnection(operatedClientConnection, httpHost, inetAddress, httpContext, httpParams);
            return;
        }
        Scheme scheme = this.schemeRegistry.getScheme(httpHost.getSchemeName());
        SchemeSocketFactory schemeSocketFactory = scheme.getSchemeSocketFactory();
        int n = scheme.resolvePort(httpHost.getPort());
        Object object2 = schemeSocketFactory.createSocket(httpParams);
        operatedClientConnection.opening((Socket)object2, httpHost);
        InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(httpHost.getHostName(), n);
        if (schemeSocketFactory.isSecure((Socket)object2)) {
            serializable = object2.getClass();
            try {
                object = serializable.getDeclaredField("host");
                ((Field)object).setAccessible(true);
                ((Field)object).set(object2, httpHost.getHostName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        serializable = null;
        if (inetAddress != null) {
            serializable = new InetSocketAddress(inetAddress, 0);
        }
        try {
            object = schemeSocketFactory.connectSocket((Socket)object2, inetSocketAddress, serializable, httpParams);
            if (object2 != object) {
                object2 = object;
                operatedClientConnection.opening((Socket)object2, httpHost);
            }
            this.prepareSocket((Socket)object2, httpContext, httpParams);
            operatedClientConnection.openCompleted(schemeSocketFactory.isSecure((Socket)object2), httpParams);
            return;
        }
        catch (ConnectException connectException) {
            throw new HttpHostConnectException(httpHost, connectException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

