/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests.config.scanner;

import com.subgraph.vega.internal.http.requests.config.IRequestEncodingStrategy;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Logger;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicRequestLine;

public class ScannerRequestEncodingStrategy
implements IRequestEncodingStrategy {
    private final String PATH_ENC_CHARS = "#&=+;,!$?%";
    private final String QUERY_ENC_CHARS = "#+;,!$?%";
    private static final Logger logger = Logger.getLogger("scanner");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public RequestLine encodeRequestLine(RequestLine requestLine) {
        String string = ScannerRequestEncodingStrategy.lineToPath(requestLine.getUri());
        String string2 = ScannerRequestEncodingStrategy.lineToQuery(requestLine.getUri());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.encodePath(string));
        if (string2 != null) {
            stringBuilder.append('?');
            stringBuilder.append(this.encodeQuery(string2));
        }
        return new BasicRequestLine(requestLine.getMethod(), stringBuilder.toString(), requestLine.getProtocolVersion());
    }

    private String encodeQuery(String string) {
        if (ScannerRequestEncodingStrategy.containsUnicode(string)) {
            try {
                return URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.warning("UnsupportedEncodingException on query: " + string);
            }
        }
        return this.encodeString(string, "#+;,!$?%");
    }

    private String encodePath(String string) {
        return this.encodeString(string, "#&=+;,!$?%");
    }

    private String encodeString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            this.encodeCharIntoBuffer(string.charAt(n), string2, stringBuilder);
            ++n;
        }
        return stringBuilder.toString();
    }

    private void encodeCharIntoBuffer(char c, String string, StringBuilder stringBuilder) {
        if (c <= ' ' || c >= '\u0080' || string.indexOf(c) != -1) {
            ScannerRequestEncodingStrategy.appendEscape(stringBuilder, c);
        } else {
            stringBuilder.append(c);
        }
    }

    private static void appendEscape(StringBuilder stringBuilder, char c) {
        stringBuilder.append('%');
        stringBuilder.append(hexDigits[c >> 4 & 0xF]);
        stringBuilder.append(hexDigits[c >> 0 & 0xF]);
    }

    private static String lineToPath(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static String lineToQuery(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    private static boolean containsUnicode(String string) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) > '\u00ff') {
                return true;
            }
            ++n;
        }
        return false;
    }
}

