/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import java.io.IOException;
import java.util.Date;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class RequestTimingHttpExecutor
extends HttpRequestExecutor {
    public static final String REQUEST_TIME = "vega.request_time";
    public static final String RESPONSE_TIME = "vega.response_time";

    protected HttpResponse doSendRequest(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpClientConnection == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse httpResponse = null;
        httpContext.setAttribute("http.connection", (Object)httpClientConnection);
        httpContext.setAttribute("http.request_sent", (Object)Boolean.FALSE);
        httpClientConnection.sendRequestHeader(httpRequest);
        httpContext.setAttribute(REQUEST_TIME, (Object)new Date());
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            boolean bl = true;
            ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
            if (((HttpEntityEnclosingRequest)httpRequest).expectContinue() && !protocolVersion.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0)) {
                httpClientConnection.flush();
                int n = httpRequest.getParams().getIntParameter("http.protocol.wait-for-continue", 2000);
                if (httpClientConnection.isResponseAvailable(n)) {
                    int n2;
                    httpResponse = httpClientConnection.receiveResponseHeader();
                    httpContext.setAttribute(RESPONSE_TIME, (Object)new Date());
                    if (this.canResponseHaveBody(httpRequest, httpResponse)) {
                        httpClientConnection.receiveResponseEntity(httpResponse);
                    }
                    if ((n2 = httpResponse.getStatusLine().getStatusCode()) < 200) {
                        if (n2 != 100) {
                            throw new ProtocolException("Unexpected response: " + httpResponse.getStatusLine());
                        }
                        httpResponse = null;
                    } else {
                        bl = false;
                    }
                }
            }
            if (bl) {
                httpClientConnection.sendRequestEntity((HttpEntityEnclosingRequest)httpRequest);
            }
        }
        httpClientConnection.flush();
        httpContext.setAttribute("http.request_sent", (Object)Boolean.TRUE);
        return httpResponse;
    }

    protected HttpResponse doReceiveResponse(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpClientConnection == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse httpResponse = null;
        int n = 0;
        while (httpResponse == null || n < 200) {
            httpResponse = httpClientConnection.receiveResponseHeader();
            httpContext.setAttribute(RESPONSE_TIME, (Object)new Date());
            if (this.canResponseHaveBody(httpRequest, httpResponse)) {
                httpClientConnection.receiveResponseEntity(httpResponse);
            }
            n = httpResponse.getStatusLine().getStatusCode();
        }
        return httpResponse;
    }
}

