/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;

public class RequestCopyHeadersInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        HttpRequest httpRequest2 = this.copyRequest(httpRequest);
        httpContext.setAttribute("vega.sent-request", (Object)httpRequest2);
    }

    private HttpRequest copyRequest(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            return this.copyEntityEnclosingRequest((HttpEntityEnclosingRequest)httpRequest);
        }
        return this.copyBasicRequest(httpRequest);
    }

    private HttpRequest copyEntityEnclosingRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest(httpEntityEnclosingRequest.getRequestLine());
        basicHttpEntityEnclosingRequest.setEntity(httpEntityEnclosingRequest.getEntity());
        RequestCopyHeadersInterceptor.copyHeaders((HttpMessage)httpEntityEnclosingRequest, (HttpMessage)basicHttpEntityEnclosingRequest);
        return basicHttpEntityEnclosingRequest;
    }

    private HttpRequest copyBasicRequest(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return null;
        }
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest(httpRequest.getRequestLine());
        RequestCopyHeadersInterceptor.copyHeaders((HttpMessage)httpRequest, (HttpMessage)basicHttpRequest);
        return basicHttpRequest;
    }

    private static void copyHeaders(HttpMessage httpMessage, HttpMessage httpMessage2) {
        Header[] headerArray = httpMessage.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            httpMessage2.addHeader((Header)new BasicHeader(header.getName(), header.getValue()));
            ++n2;
        }
    }
}

