/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.EntityUtils;

public class RepeatableStreamingEntity
extends AbstractHttpEntity {
    private static final int BUFFER_SIZE = 8192;
    private boolean isStreaming = true;
    private long length;
    private long maximumInputKilobytes = 0L;
    private HttpEntity bufferEntity;
    private volatile InputStream input;

    RepeatableStreamingEntity(InputStream inputStream, long l, boolean bl, boolean bl2, String string, String string2) throws IOException {
        this.setChunked(bl2);
        this.setContentType(string);
        this.setContentEncoding(string2);
        this.setActiveInputStream(inputStream, l);
        if (bl) {
            this.consumeAllInput();
        }
    }

    RepeatableStreamingEntity(HttpEntity httpEntity) throws IOException {
        this.copyEntityProperties(httpEntity);
        if (httpEntity.isStreaming()) {
            this.setActiveInputStream(httpEntity.getContent(), httpEntity.getContentLength());
        } else {
            this.setActiveByteArrayEntity(EntityUtils.toByteArray((HttpEntity)httpEntity));
        }
    }

    void setMaximumInputKilobytes(int n) {
        this.maximumInputKilobytes = n;
    }

    private void copyEntityProperties(HttpEntity httpEntity) {
        this.setChunked(httpEntity.isChunked());
        if (httpEntity.getContentType() != null) {
            this.setContentType(httpEntity.getContentType().getValue());
        }
        if (httpEntity.getContentEncoding() != null) {
            this.setContentEncoding(httpEntity.getContentType().getValue());
        }
        this.length = httpEntity.getContentLength();
    }

    private void setActiveInputStream(InputStream inputStream, long l) {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HTTP entity is too large to be buffered in memory: " + l);
        }
        this.length = l;
        int n = l < 0L ? 8192 : (int)l;
        this.input = new CachingInputStream(inputStream, n);
        this.isStreaming = true;
    }

    private void setActiveByteArrayEntity(byte[] byArray) {
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray);
        this.isStreaming = false;
        this.length = byArray.length;
        this.bufferEntity = byteArrayEntity;
        this.input = null;
    }

    private void consumeAllInput() throws IOException {
        if (this.length < 0L) {
            int n;
            while ((n = this.input.read()) != -1) {
            }
        } else {
            int n = (int)this.length;
            byte[] byArray = new byte[8192];
            while (n > 0) {
                int n2 = n < 8192 ? n : 8192;
                int n3 = this.input.read(byArray, 0, n2);
                if (n3 == -1) break;
                n -= n3;
            }
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException {
        if (this.input != null) {
            return this.input;
        }
        return this.bufferEntity.getContent();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        block9: {
            if (this.input == null) {
                this.bufferEntity.writeTo(outputStream);
                return;
            }
            byte[] byArray = new byte[8192];
            try {
                if (this.length < 0L) {
                    int n;
                    while ((n = this.input.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n);
                    }
                    break block9;
                }
                long l = this.length;
                while (l > 0L) {
                    int n = l < 8192L ? (int)l : 8192;
                    int n2 = this.input.read(byArray, 0, n);
                    if (n2 == -1) {
                        break;
                    }
                    outputStream.write(byArray, 0, n2);
                    l -= (long)n2;
                }
            }
            finally {
                if (this.input != null) {
                    this.input.close();
                    this.input = null;
                }
            }
        }
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public void consumeContent() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.bufferEntity != null) {
            EntityUtils.consume((HttpEntity)this.bufferEntity);
        }
    }

    private class CachingInputStream
    extends InputStream {
        private final InputStream wrappedInput;
        private ByteArrayBuffer buffer;
        private boolean eof;

        CachingInputStream(InputStream inputStream, int n) {
            this.wrappedInput = inputStream;
            this.buffer = new ByteArrayBuffer(n);
        }

        @Override
        public int read() throws IOException {
            if (this.eof) {
                return -1;
            }
            int n = this.wrappedInput.read();
            if (n == -1) {
                this.processEOF();
            } else {
                this.buffer.append(n);
            }
            this.checkMaximumLength();
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.eof) {
                return -1;
            }
            int n3 = this.wrappedInput.read(byArray, n, n2);
            if (n3 == -1) {
                this.processEOF();
            } else {
                this.buffer.append(byArray, n, n3);
            }
            this.checkMaximumLength();
            return n3;
        }

        private void checkMaximumLength() throws IOException {
            if (RepeatableStreamingEntity.this.maximumInputKilobytes > 0L && (long)this.buffer.length() > RepeatableStreamingEntity.this.maximumInputKilobytes * 1024L) {
                this.wrappedInput.close();
                this.eof = true;
                this.buffer = null;
                RepeatableStreamingEntity.this.setActiveByteArrayEntity(new byte[0]);
                throw new IOException("Maximum length of " + RepeatableStreamingEntity.this.maximumInputKilobytes + " kb exceeded while streaming http entity.");
            }
        }

        @Override
        public void close() throws IOException {
            this.wrappedInput.close();
            if (!this.eof) {
                RepeatableStreamingEntity.this.setActiveByteArrayEntity(this.buffer.toByteArray());
            }
        }

        private void processEOF() throws IOException {
            this.wrappedInput.close();
            this.eof = true;
            RepeatableStreamingEntity.this.setActiveByteArrayEntity(this.buffer.toByteArray());
        }
    }
}

