/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import com.subgraph.vega.api.html.IHTMLParser;
import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineConfig;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.http.requests.builder.HttpRequestBuilder;
import com.subgraph.vega.http.requests.builder.HttpResponseBuilder;
import com.subgraph.vega.internal.http.requests.BasicHttpClientFactory;
import com.subgraph.vega.internal.http.requests.HttpRequestEngine;
import com.subgraph.vega.internal.http.requests.HttpRequestEngineConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

public class HttpRequestEngineFactory
implements IHttpRequestEngineFactory {
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private IHTMLParser htmlParser;
    private HttpHost proxy;

    public void setProxy(HttpHost httpHost) {
        this.proxy = httpHost;
    }

    public IHttpRequestEngineConfig createConfig() {
        return new HttpRequestEngineConfig();
    }

    public IHttpRequestEngine createRequestEngine(IHttpRequestEngine.EngineConfigType engineConfigType, IHttpRequestEngineConfig iHttpRequestEngineConfig, IRequestOrigin iRequestOrigin) {
        HttpClient httpClient = BasicHttpClientFactory.createHttpClient(engineConfigType);
        if (this.proxy != null) {
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)this.proxy);
        }
        this.configureClient(httpClient, iHttpRequestEngineConfig);
        return new HttpRequestEngine(engineConfigType, this.executor, httpClient, iHttpRequestEngineConfig, iRequestOrigin, this.htmlParser);
    }

    public IHttpRequestBuilder createRequestBuilder() {
        return new HttpRequestBuilder();
    }

    public IHttpResponseBuilder createResponseBuilder() {
        return new HttpResponseBuilder();
    }

    private void configureClient(HttpClient httpClient, IHttpRequestEngineConfig iHttpRequestEngineConfig) {
        ClientConnectionManager clientConnectionManager = httpClient.getConnectionManager();
        if (clientConnectionManager instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager poolingClientConnectionManager = (PoolingClientConnectionManager)clientConnectionManager;
            poolingClientConnectionManager.setMaxTotal(iHttpRequestEngineConfig.getMaxConnections());
            poolingClientConnectionManager.setDefaultMaxPerRoute(iHttpRequestEngineConfig.getMaxConnectionsPerRoute());
        }
    }

    protected void setHTMLParser(IHTMLParser iHTMLParser) {
        this.htmlParser = iHTMLParser;
    }

    protected void unsetHTMLParser(IHTMLParser iHTMLParser) {
        this.htmlParser = null;
    }
}

