/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.html.IHTMLParser;
import com.subgraph.vega.api.http.requests.IHttpMacroContext;
import com.subgraph.vega.api.http.requests.IHttpMacroExecutor;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineConfig;
import com.subgraph.vega.api.http.requests.IHttpRequestModifier;
import com.subgraph.vega.api.http.requests.IHttpRequestTask;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.RequestTaskStartEvent;
import com.subgraph.vega.api.http.requests.RequestTaskStopEvent;
import com.subgraph.vega.api.model.macros.IHttpMacro;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.http.requests.custom.IEncodableHttpRequest;
import com.subgraph.vega.http.requests.custom.VegaHttpEntityEnclosingUriRequest;
import com.subgraph.vega.http.requests.custom.VegaHttpUriRequest;
import com.subgraph.vega.internal.http.requests.CookieMatcher;
import com.subgraph.vega.internal.http.requests.HttpMacroContext;
import com.subgraph.vega.internal.http.requests.HttpMacroExecutor;
import com.subgraph.vega.internal.http.requests.HttpRequestTask;
import com.subgraph.vega.internal.http.requests.RateLimiter;
import com.subgraph.vega.internal.http.requests.client.VegaDecompressingHttpClient;
import com.subgraph.vega.internal.http.requests.config.IRequestEncodingStrategy;
import com.subgraph.vega.internal.http.requests.config.RequestEngineConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.SyncBasicHttpContext;

public class HttpRequestEngine
implements IHttpRequestEngine {
    public static final String VEGA_SENT_REQUEST = "vega.sent-request";
    private static final boolean isDecompressingClient = true;
    private final IRequestEncodingStrategy encodingStrategy;
    private final ExecutorService executor;
    private final HttpClient client;
    private final HttpClient decompressingClient;
    private final IHttpRequestEngineConfig config;
    private final IRequestOrigin requestOrigin;
    private final IHTMLParser htmlParser;
    private final RateLimiter rateLimit;
    private final CookieMatcher cookieMatcher;
    private final HttpContext httpContext;
    private final List<IHttpRequestModifier> requestModifierList;
    private final EventListenerManager requestEventManager;
    private final List<HttpRequestTask> requestInProgressList;

    HttpRequestEngine(IHttpRequestEngine.EngineConfigType engineConfigType, ExecutorService executorService, HttpClient httpClient, IHttpRequestEngineConfig iHttpRequestEngineConfig, IRequestOrigin iRequestOrigin, IHTMLParser iHTMLParser) {
        this.encodingStrategy = RequestEngineConfig.getRequestEncodingStrategy(engineConfigType);
        this.executor = executorService;
        this.client = httpClient;
        this.decompressingClient = new VegaDecompressingHttpClient(httpClient);
        this.config = iHttpRequestEngineConfig;
        this.requestOrigin = iRequestOrigin;
        this.htmlParser = iHTMLParser;
        this.rateLimit = new RateLimiter(iHttpRequestEngineConfig.getRequestsPerMinute());
        this.cookieMatcher = new CookieMatcher(this.getClientDowncast());
        this.httpContext = new SyncBasicHttpContext(null);
        this.requestModifierList = new ArrayList<IHttpRequestModifier>();
        this.requestEventManager = new EventListenerManager();
        this.requestInProgressList = new ArrayList<HttpRequestTask>();
    }

    public IHttpRequestEngineConfig getRequestEngineConfig() {
        return this.config;
    }

    public IRequestOrigin getRequestOrigin() {
        return this.requestOrigin;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public CookieStore getCookieStore() {
        return this.getClientDowncast().getCookieStore();
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.getClientDowncast().setCookieStore(cookieStore);
    }

    private AbstractHttpClient getClientDowncast() {
        if (this.client instanceof AbstractHttpClient) {
            return (AbstractHttpClient)this.client;
        }
        throw new IllegalArgumentException("HttpClient instance is not expected type");
    }

    public void addRequestModifier(IHttpRequestModifier iHttpRequestModifier) {
        this.requestModifierList.add(iHttpRequestModifier);
    }

    public void addRequestListener(IEventHandler iEventHandler) {
        this.requestEventManager.addListener(iEventHandler);
    }

    public void removeRequestListener(IEventHandler iEventHandler) {
        this.requestEventManager.removeListener(iEventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpRequestTask[] getRequestList() {
        HttpRequestEngine httpRequestEngine = this;
        synchronized (httpRequestEngine) {
            return this.requestInProgressList.toArray(new IHttpRequestTask[0]);
        }
    }

    public IHttpRequestTask sendRequest(HttpUriRequest httpUriRequest, HttpContext httpContext) {
        if (httpUriRequest instanceof IEncodableHttpRequest) {
            ((IEncodableHttpRequest)httpUriRequest).encodeWith(this.encodingStrategy);
        }
        for (IHttpRequestModifier object2 : this.requestModifierList) {
            object2.process((HttpRequest)httpUriRequest, httpContext);
        }
        HttpRequestTask httpRequestTask = new HttpRequestTask(this, this.decompressingClient, this.rateLimit, httpUriRequest, this.requestOrigin, httpContext, this.config, this.htmlParser);
        Future<IHttpResponse> future = this.executor.submit(httpRequestTask);
        httpRequestTask.setFuture(future);
        return httpRequestTask;
    }

    public IHttpRequestTask sendRequest(HttpUriRequest httpUriRequest) {
        return this.sendRequest(httpUriRequest, (HttpContext)new BasicHttpContext(this.httpContext));
    }

    public IHttpMacroContext createMacroContext() {
        return new HttpMacroContext();
    }

    public IHttpMacroExecutor createMacroExecutor(IHttpMacro iHttpMacro, IHttpMacroContext iHttpMacroContext) {
        return new HttpMacroExecutor(this, iHttpMacro, iHttpMacroContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestInProgress(HttpRequestTask httpRequestTask) {
        HttpRequestEngine httpRequestEngine = this;
        synchronized (httpRequestEngine) {
            this.requestInProgressList.add(httpRequestTask);
            this.requestEventManager.fireEvent((IEvent)new RequestTaskStartEvent((IHttpRequestTask)httpRequestTask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestInProgress(HttpRequestTask httpRequestTask) {
        HttpRequestEngine httpRequestEngine = this;
        synchronized (httpRequestEngine) {
            this.requestInProgressList.remove(httpRequestTask);
            this.requestEventManager.fireEvent((IEvent)new RequestTaskStopEvent((IHttpRequestTask)httpRequestTask));
        }
    }

    public HttpUriRequest createGetRequest(HttpHost httpHost, String string) {
        return new VegaHttpUriRequest(httpHost, "GET", string);
    }

    public HttpUriRequest createPostRequest(HttpHost httpHost, String string) {
        return new VegaHttpEntityEnclosingUriRequest(httpHost, "POST", string);
    }

    public HttpUriRequest createRawRequest(HttpHost httpHost, RequestLine requestLine) {
        return new VegaHttpUriRequest(httpHost, requestLine);
    }

    public HttpUriRequest createRawEntityEnclosingRequest(HttpHost httpHost, RequestLine requestLine) {
        return new VegaHttpEntityEnclosingUriRequest(httpHost, requestLine);
    }

    public List<Cookie> getCookiesForRequest(HttpHost httpHost, HttpRequest httpRequest) {
        return this.cookieMatcher.getCookiesForRequest(httpHost, httpRequest);
    }
}

