/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.requesteditviewer;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.RequestEngineException;
import com.subgraph.vega.ui.http.requesteditviewer.RequestEditView;
import org.apache.http.client.methods.HttpUriRequest;

public class SendRequestTask
implements Runnable {
    private final HttpUriRequest request;
    private final RequestEditView view;
    private final IHttpRequestEngine requestEngine;
    private final Thread sendingThread;

    SendRequestTask(HttpUriRequest httpUriRequest, RequestEditView requestEditView, IHttpRequestEngine iHttpRequestEngine) {
        this.request = httpUriRequest;
        this.view = requestEditView;
        this.requestEngine = iHttpRequestEngine;
        this.sendingThread = new Thread(this);
    }

    void start() {
        this.sendingThread.start();
    }

    @Override
    public void run() {
        try {
            IHttpResponse iHttpResponse = this.requestEngine.sendRequest(this.request).get(true);
            this.view.processResponse(iHttpResponse);
        }
        catch (RequestEngineException requestEngineException) {
            this.view.processResponse(null);
            this.view.displayExceptionError((Exception)requestEngineException.getCause());
            return;
        }
    }
}

