/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.preferencepage;

import com.subgraph.vega.api.http.proxy.IHttpProxyListenerConfig;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.preferencepage.IPreferenceConstants;
import com.subgraph.vega.ui.http.preferencepage.ListenerAddressDialog;
import com.subgraph.vega.ui.http.preferencepage.ListenerTableContentProvider;
import com.subgraph.vega.ui.util.preferences.VegaPreferencePage;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;

public class ProxyListenerPreferencePage
extends VegaPreferencePage
implements IPreferenceConstants {
    private static final String SEPARATOR_LISTENER = ";";
    private static final String SEPARATOR_ADDRESS_PORT = ":";
    private Composite parentComposite;
    private TableViewer listenersTableViewer;
    private Button buttonCreate;
    private Button buttonRemove;
    private ArrayList<IHttpProxyListenerConfig> listenerList = new ArrayList();

    public ProxyListenerPreferencePage() {
        super("Proxy Listen Address");
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createPage(Composite composite) {
        this.parentComposite = new SashForm(composite, 512);
        this.createListenAddressGroup(this.parentComposite);
        ProxyListenerPreferencePage.parsePreferencesString(this.listenerList, this.getPreferenceStore().getString("ProxyListeners"));
        this.listenersTableViewer.setInput(this.listenerList);
        return this.parentComposite;
    }

    protected void performDefaults() {
        super.performDefaults();
        ProxyListenerPreferencePage.parsePreferencesString(this.listenerList, this.getPreferenceStore().getDefaultString("ProxyListeners"));
        this.listenersTableViewer.setInput(this.listenerList);
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        if (bl) {
            this.getPreferenceStore().setValue("ProxyListeners", this.getPreferencesString());
        }
        return bl;
    }

    public static void parsePreferencesString(ArrayList<IHttpProxyListenerConfig> arrayList, String string) {
        arrayList.clear();
        if (string != null) {
            String[] stringArray = string.split(SEPARATOR_LISTENER);
            int n = 0;
            while (n < stringArray.length) {
                String[] stringArray2 = stringArray[n].split(SEPARATOR_ADDRESS_PORT);
                try {
                    IHttpProxyListenerConfig iHttpProxyListenerConfig = Activator.getDefault().getProxyService().createListenerConfig();
                    InetAddress inetAddress = InetAddress.getByName(stringArray2[0].substring(1, stringArray2[0].length() - 1));
                    iHttpProxyListenerConfig.setInetAddress(inetAddress);
                    iHttpProxyListenerConfig.setPort(Integer.parseInt(stringArray2[1]));
                    arrayList.add(iHttpProxyListenerConfig);
                }
                catch (Exception exception) {}
                ++n;
            }
        }
    }

    private String getPreferencesString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.listenerList.size()) {
            IHttpProxyListenerConfig iHttpProxyListenerConfig = this.listenerList.get(n);
            if (n != 0) {
                stringBuilder.append(SEPARATOR_LISTENER);
            }
            stringBuilder.append("[");
            stringBuilder.append(iHttpProxyListenerConfig.getInetAddress().getHostAddress());
            stringBuilder.append("]");
            stringBuilder.append(SEPARATOR_ADDRESS_PORT);
            stringBuilder.append(Integer.toString(iHttpProxyListenerConfig.getPort()));
            ++n;
        }
        return stringBuilder.toString();
    }

    private Composite createListenAddressGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Listen Addresses");
        Composite composite2 = this.createListenerTable((Composite)group);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite3 = this.createListenerTableButtons((Composite)group);
        composite3.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        return group;
    }

    private Composite createListenerTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.listenersTableViewer = new TableViewer(composite2, 68354);
        this.listenersTableViewer.setContentProvider((IContentProvider)new ListenerTableContentProvider());
        this.listenersTableViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.createListenerTableColumns(this.listenersTableViewer, tableColumnLayout);
        Table table = this.listenersTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return composite2;
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                boolean bl = selectionChangedEvent.getSelection().isEmpty();
                ProxyListenerPreferencePage.this.buttonRemove.setGrayed(bl);
            }
        };
    }

    private void createListenerTableColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        String[] stringArray = new String[]{"IP Address", "Port"};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnWeightData(100, 100, true), new ColumnPixelData(80, true, true)};
        ColumnLabelProvider[] columnLabelProviderArray = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpProxyListenerConfig)object).getInetAddress().getHostAddress();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return Integer.toString(((IHttpProxyListenerConfig)object).getPort());
            }
        }};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableColumn.setText(stringArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProviderArray[n]);
            ++n;
        }
    }

    private Composite createListenerTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.buttonCreate = new Button(composite2, 8);
        this.buttonCreate.setText("create");
        this.buttonCreate.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonCreate.addSelectionListener(this.createSelectionListenerButtonCreate());
        this.buttonRemove = new Button(composite2, 8);
        this.buttonRemove.setText("remove");
        this.buttonRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonRemove.setGrayed(true);
        this.buttonRemove.addSelectionListener(this.createSelectionListenerButtonRemove());
        return composite2;
    }

    private SelectionListener createSelectionListenerButtonCreate() {
        final ProxyListenerPreferencePage proxyListenerPreferencePage = this;
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListenerAddressDialog listenerAddressDialog = new ListenerAddressDialog(ProxyListenerPreferencePage.this.parentComposite.getShell(), proxyListenerPreferencePage);
                listenerAddressDialog.create();
                if (listenerAddressDialog.open() == 0) {
                    ProxyListenerPreferencePage.this.listenerList.add(listenerAddressDialog.getConfig());
                    ProxyListenerPreferencePage.this.listenersTableViewer.refresh();
                }
            }
        };
    }

    private SelectionListener createSelectionListenerButtonRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ProxyListenerPreferencePage.this.listenersTableViewer.getSelection();
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    ProxyListenerPreferencePage.this.listenerList.remove((IHttpProxyListenerConfig)iterator.next());
                }
                ProxyListenerPreferencePage.this.listenersTableViewer.refresh();
            }
        };
    }

    public boolean hasListener(InetAddress inetAddress, int n) {
        for (IHttpProxyListenerConfig iHttpProxyListenerConfig : this.listenerList) {
            if (!iHttpProxyListenerConfig.getInetAddress().equals(inetAddress) || iHttpProxyListenerConfig.getPort() != n) continue;
            return true;
        }
        return false;
    }
}

