/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.preferencepage;

import com.subgraph.vega.api.http.proxy.IHttpProxyListenerConfig;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.preferencepage.ProxyListenerPreferencePage;
import com.subgraph.vega.ui.util.dialogs.ErrorDialog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ListenerAddressDialog
extends Dialog {
    private ProxyListenerPreferencePage page;
    private Composite parentComposite;
    private Text ipAddress;
    private Text port;
    private int portNum;
    private InetAddress inetAddress;

    public ListenerAddressDialog(Shell shell, ProxyListenerPreferencePage proxyListenerPreferencePage) {
        super(shell);
        this.page = proxyListenerPreferencePage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add Listen Address");
    }

    protected Control createDialogArea(Composite composite) {
        this.parentComposite = (Composite)super.createDialogArea(composite);
        this.createFields(this.parentComposite);
        return this.parentComposite;
    }

    protected void okPressed() {
        if (this.parseInput()) {
            super.okPressed();
        }
    }

    private Composite createFields(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(composite2, 0);
        label.setText("IP Address:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.ipAddress = new Text(composite2, 2048);
        this.ipAddress.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                String string = event.text;
                char[] cArray = new char[string.length()];
                string.getChars(0, cArray.length, cArray, 0);
                int n = 0;
                while (n < cArray.length) {
                    if (('0' > cArray[n] || cArray[n] > '9') && cArray[n] != '.') {
                        event.doit = false;
                        return;
                    }
                    ++n;
                }
            }
        });
        label = new Label(composite2, 0);
        label.setText("Port:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.port = new Text(composite2, 2048);
        this.port.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.port.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                String string = event.text;
                char[] cArray = new char[string.length()];
                string.getChars(0, cArray.length, cArray, 0);
                int n = 0;
                while (n < cArray.length) {
                    if ('0' > cArray[n] || cArray[n] > '9') {
                        event.doit = false;
                        return;
                    }
                    ++n;
                }
            }
        });
        return composite2;
    }

    public IHttpProxyListenerConfig getConfig() {
        IHttpProxyListenerConfig iHttpProxyListenerConfig = Activator.getDefault().getProxyService().createListenerConfig();
        iHttpProxyListenerConfig.setInetAddress(this.inetAddress);
        iHttpProxyListenerConfig.setPort(this.portNum);
        return iHttpProxyListenerConfig;
    }

    private boolean parseInput() {
        try {
            this.inetAddress = InetAddress.getByName(this.ipAddress.getText());
        }
        catch (UnknownHostException unknownHostException) {
            ErrorDialog.displayError((Shell)this.getShell(), (String)"Invalid IP address");
            return false;
        }
        try {
            this.portNum = Integer.parseInt(this.port.getText());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorDialog.displayError((Shell)this.getShell(), (String)"Invalid port: must be between 1 and 65535");
            return false;
        }
        if (this.portNum < 1 || this.portNum > 65535) {
            ErrorDialog.displayError((Shell)this.getShell(), (String)"Invalid port: must be between 1 and 65535");
            return false;
        }
        if (this.page.hasListener(this.inetAddress, this.portNum)) {
            ErrorDialog.displayError((Shell)this.getShell(), (String)"IP address/port combination is already registered");
            return false;
        }
        return true;
    }
}

