/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.conditions;

import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.ui.http.conditions.MatchActionComboViewer;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class ConditionTypeComboViewer
extends ComboViewer {
    private MatchActionComboViewer matchActionViewer;

    public ConditionTypeComboViewer(Composite composite, List<IHttpConditionType> list) {
        super(composite, 8);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.addSelectionChangedListener(this.createSelectionChangedListener());
        this.setInput(list.toArray());
        this.reset();
    }

    private ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof IHttpConditionType) {
                    return ((IHttpConditionType)object).getName();
                }
                return null;
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ConditionTypeComboViewer.this.setMatchActionInputForSelection(selectionChangedEvent.getSelection());
            }
        };
    }

    public void reset() {
        Object object = this.getElementAt(0);
        if (object != null) {
            this.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    public void setMatchTypeViewer(MatchActionComboViewer matchActionComboViewer) {
        this.matchActionViewer = matchActionComboViewer;
        this.setMatchActionInputForSelection(this.getSelection());
    }

    private void setMatchActionInputForSelection(ISelection iSelection) {
        if (this.matchActionViewer == null || !(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (!(iStructuredSelection.getFirstElement() instanceof IHttpConditionType)) {
            return;
        }
        IHttpConditionType iHttpConditionType = (IHttpConditionType)iStructuredSelection.getFirstElement();
        this.matchActionViewer.setMatchActionInput(iHttpConditionType.getMatchActions());
    }

    public IHttpConditionType getSelectedConditionType() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return null;
        }
        return (IHttpConditionType)iStructuredSelection.getFirstElement();
    }
}

