/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.builder;

import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import com.subgraph.vega.ui.http.builder.BuilderParseException;
import com.subgraph.vega.ui.http.builder.IHttpBuilderPart;
import com.subgraph.vega.ui.httpeditor.HttpMessageEditor;
import com.subgraph.vega.ui.httpeditor.parser.HttpResponseParser;
import java.io.UnsupportedEncodingException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ResponseMessageEditor
extends Composite
implements IHttpBuilderPart {
    private final IHttpResponseBuilder builder;
    private final HttpResponseParser responseParser;
    private HttpMessageEditor messageViewer;

    public ResponseMessageEditor(Composite composite, IHttpResponseBuilder iHttpResponseBuilder) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.builder = iHttpResponseBuilder;
        this.responseParser = new HttpResponseParser(this.builder, false);
        this.messageViewer = new HttpMessageEditor((Composite)this);
        this.messageViewer.setEditable(true);
        this.messageViewer.setDisplayImages(true);
        this.messageViewer.setDisplayImagesAsHex(true);
        this.refresh();
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public void setEditable(boolean bl) {
        this.messageViewer.setEditable(bl);
    }

    @Override
    public void refresh() {
        this.messageViewer.displayHttpResponse(this.builder);
    }

    @Override
    public void processContents() throws BuilderParseException {
        try {
            this.responseParser.parseResponse(this.messageViewer.getContent());
            if (this.messageViewer.isEntityContentDirty()) {
                this.builder.setEntity(this.messageViewer.getEntityContent());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BuilderParseException("Error getting entity", unsupportedEncodingException);
        }
    }
}

