/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.builder;

import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.ui.http.builder.BuilderParseException;
import com.subgraph.vega.ui.http.builder.IHttpBuilderPart;
import com.subgraph.vega.ui.httpeditor.HttpMessageEditor;
import com.subgraph.vega.ui.httpeditor.parser.HttpRequestParser;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RequestMessageEditor
extends Composite
implements IHttpBuilderPart {
    private final IHttpRequestBuilder builder;
    private final HttpRequestParser requestParser;
    private HttpMessageEditor messageViewer;

    public RequestMessageEditor(Composite composite, IHttpRequestBuilder iHttpRequestBuilder) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.builder = iHttpRequestBuilder;
        this.requestParser = new HttpRequestParser(this.builder, false);
        this.messageViewer = new HttpMessageEditor((Composite)this);
        this.messageViewer.setEditable(true);
        this.messageViewer.setDisplayImages(true);
        this.messageViewer.setDisplayImagesAsHex(true);
        this.refresh();
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public void setEditable(boolean bl) {
        this.messageViewer.setEditable(bl);
    }

    @Override
    public void refresh() {
        this.messageViewer.displayHttpRequest(this.builder);
    }

    @Override
    public void processContents() throws BuilderParseException {
        try {
            this.requestParser.parseRequest(this.messageViewer.getContent());
            if (this.messageViewer.isEntityContentDirty()) {
                this.builder.setEntity(this.messageViewer.getEntityContent());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BuilderParseException("Error getting entity", unsupportedEncodingException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new BuilderParseException("Error parsing URI", uRISyntaxException);
        }
    }
}

