/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.builder;

import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.ui.http.builder.IHttpBuilderPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RequestAddressEditor
extends Composite
implements IHttpBuilderPart {
    private String[] requestSchemes = new String[]{"http", "https"};
    private IHttpRequestBuilder requestBuilder;
    private ComboViewer requestScheme;
    private Text requestHost;
    private Text requestPort;

    public RequestAddressEditor(Composite composite, IHttpRequestBuilder iHttpRequestBuilder) {
        super(composite, 0);
        this.requestBuilder = iHttpRequestBuilder;
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        this.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label label = new Label(composite2, 0);
        label.setText("Scheme:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.requestScheme = new ComboViewer(composite2, 8);
        this.requestScheme.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.requestScheme.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return (String)object;
            }
        });
        this.requestScheme.setInput((Object)this.requestSchemes);
        this.requestScheme.setSelection((ISelection)new StructuredSelection((Object)this.requestSchemes[0]));
        this.requestScheme.addSelectionChangedListener(this.createSelectionChangedListenerRequestScheme());
        Composite composite3 = new Composite((Composite)this, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label = new Label(composite3, 0);
        label.setText("Host:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.requestHost = new Text(composite3, 2052);
        this.requestHost.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite composite4 = new Composite((Composite)this, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        composite4.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        label = new Label(composite4, 0);
        label.setText("Port:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.requestPort = new Text(composite4, 2052);
        FontMetrics fontMetrics = new GC((Drawable)this.requestPort).getFontMetrics();
        GridData gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData.widthHint = fontMetrics.getAverageCharWidth() * 7;
        this.requestPort.setLayoutData((Object)gridData);
        this.requestPort.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                String string = event.text;
                char[] cArray = new char[string.length()];
                string.getChars(0, cArray.length, cArray, 0);
                int n = 0;
                while (n < cArray.length) {
                    if ('0' > cArray[n] || cArray[n] > '9') {
                        event.doit = false;
                        return;
                    }
                    ++n;
                }
            }
        });
        this.refresh();
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public void setEditable(boolean bl) {
        this.requestScheme.getCombo().setEnabled(bl);
        this.requestHost.setEditable(bl);
        this.requestPort.setEditable(bl);
    }

    @Override
    public void refresh() {
        this.requestScheme.setSelection((ISelection)new StructuredSelection((Object)this.requestBuilder.getScheme()));
        this.requestHost.setText(this.requestBuilder.getHost());
        this.requestPort.setText(Integer.toString(this.requestBuilder.getHostPort()));
    }

    @Override
    public void processContents() {
        String string = (String)((IStructuredSelection)this.requestScheme.getSelection()).getFirstElement();
        this.requestBuilder.setScheme(string);
        this.requestBuilder.setHost(this.requestHost.getText().trim());
        try {
            this.requestBuilder.setHostPort(Integer.parseInt(this.requestPort.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid host port");
        }
    }

    private ISelectionChangedListener createSelectionChangedListenerRequestScheme() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                String string = (String)((IStructuredSelection)RequestAddressEditor.this.requestScheme.getSelection()).getFirstElement();
                if (string.equals("https")) {
                    RequestAddressEditor.this.requestPort.setText("443");
                } else {
                    RequestAddressEditor.this.requestPort.setText("80");
                }
            }
        };
    }
}

