/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http;

import com.subgraph.vega.api.analysis.IContentAnalyzerFactory;
import com.subgraph.vega.api.http.proxy.IHttpProxyListenerConfig;
import com.subgraph.vega.api.http.proxy.IHttpProxyService;
import com.subgraph.vega.api.http.proxy.IHttpProxyTransactionManipulator;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.scanner.modules.IScannerModuleRegistry;
import com.subgraph.vega.internal.ui.http.ProxyServiceTrackerCustomizer;
import com.subgraph.vega.internal.ui.http.ProxyStatusLineContribution;
import com.subgraph.vega.ui.http.preferencepage.ProxyListenerPreferencePage;
import java.util.ArrayList;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.subgraph.vega.ui.http";
    private static Activator plugin;
    private ServiceTracker<IModel, IModel> modelTracker;
    private ProxyServiceTrackerCustomizer proxyServiceTrackerCustomizer;
    private ServiceTracker<IHttpProxyService, IHttpProxyService> proxyServiceTracker;
    private ServiceTracker<IHttpRequestEngineFactory, IHttpRequestEngineFactory> httpRequestEngineFactoryServiceTracker;
    private ServiceTracker<IContentAnalyzerFactory, IContentAnalyzerFactory> contentAnalyzerFactoryTracker;
    private ServiceTracker<IScannerModuleRegistry, IScannerModuleRegistry> scannerModuleRegistryTracker;
    private ProxyStatusLineContribution statusLineContribution = new ProxyStatusLineContribution();

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.modelTracker = new ServiceTracker(bundleContext, IModel.class.getName(), null);
        this.modelTracker.open();
        this.proxyServiceTrackerCustomizer = new ProxyServiceTrackerCustomizer(bundleContext, this.statusLineContribution);
        this.proxyServiceTracker = new ServiceTracker(bundleContext, IHttpProxyService.class.getName(), (ServiceTrackerCustomizer)this.proxyServiceTrackerCustomizer);
        this.proxyServiceTracker.open();
        this.setProxyListenerAddresses();
        this.setProxyTransactionManipulator();
        this.httpRequestEngineFactoryServiceTracker = new ServiceTracker(bundleContext, IHttpRequestEngineFactory.class.getName(), null);
        this.httpRequestEngineFactoryServiceTracker.open();
        this.contentAnalyzerFactoryTracker = new ServiceTracker(bundleContext, IContentAnalyzerFactory.class.getName(), null);
        this.contentAnalyzerFactoryTracker.open();
        this.scannerModuleRegistryTracker = new ServiceTracker(bundleContext, IScannerModuleRegistry.class.getName(), null);
        this.scannerModuleRegistryTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }

    public IModel getModel() {
        return (IModel)this.modelTracker.getService();
    }

    public IHttpProxyService getProxyService() {
        return (IHttpProxyService)this.proxyServiceTracker.getService();
    }

    public IHttpRequestEngineFactory getHttpRequestEngineFactoryService() {
        return (IHttpRequestEngineFactory)this.httpRequestEngineFactoryServiceTracker.getService();
    }

    public IContentAnalyzerFactory getContentAnalyzerFactoryService() {
        return (IContentAnalyzerFactory)this.contentAnalyzerFactoryTracker.getService();
    }

    public IScannerModuleRegistry getScannerModuleRegistry() {
        return (IScannerModuleRegistry)this.scannerModuleRegistryTracker.getService();
    }

    public ContributionItem getStatusLineContribution() {
        return this.statusLineContribution;
    }

    private void setProxyListenerAddresses() {
        this.updateProxyListenerAddresses();
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty() == "ProxyListeners") {
                    Activator.this.updateProxyListenerAddresses();
                }
            }
        });
    }

    private void updateProxyListenerAddresses() {
        ArrayList<IHttpProxyListenerConfig> arrayList = new ArrayList<IHttpProxyListenerConfig>();
        String string = this.getPreferenceStore().getString("ProxyListeners");
        ProxyListenerPreferencePage.parsePreferencesString(arrayList, string);
        IHttpProxyService iHttpProxyService = this.getProxyService();
        iHttpProxyService.setListenerConfigs(arrayList.toArray(new IHttpProxyListenerConfig[0]));
    }

    private void setProxyTransactionManipulator() {
        IHttpProxyTransactionManipulator iHttpProxyTransactionManipulator = this.getProxyService().getTransactionManipulator();
        final IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iHttpProxyTransactionManipulator.setUserAgent(iPreferenceStore.getString("UserAgent"));
        iHttpProxyTransactionManipulator.setUserAgentOverride(iPreferenceStore.getBoolean("UserAgentOverride"));
        iHttpProxyTransactionManipulator.setBrowserCacheDisable(iPreferenceStore.getBoolean("DisableBrowserCache"));
        iHttpProxyTransactionManipulator.setProxyCacheDisable(iPreferenceStore.getBoolean("DisableProxyCache"));
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IHttpProxyTransactionManipulator iHttpProxyTransactionManipulator = Activator.this.getProxyService().getTransactionManipulator();
                String string = propertyChangeEvent.getProperty();
                if (string == "UserAgent") {
                    iHttpProxyTransactionManipulator.setUserAgent(iPreferenceStore.getString("UserAgent"));
                } else if (string == "UserAgentOverride") {
                    iHttpProxyTransactionManipulator.setUserAgentOverride(iPreferenceStore.getBoolean("UserAgentOverride"));
                } else if (string == "DisableBrowserCache") {
                    iHttpProxyTransactionManipulator.setBrowserCacheDisable(iPreferenceStore.getBoolean("DisableBrowserCache"));
                } else if (string == "DisableProxyCache") {
                    iHttpProxyTransactionManipulator.setProxyCacheDisable(iPreferenceStore.getBoolean("DisableProxyCache"));
                }
            }
        });
    }
}

