/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.ui.http.requestlogviewer;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.conditions.ConditionSetChanged;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.model.requests.IRequestLogNewRecordListener;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.api.model.requests.RequestLogNewRecordEvent;
import com.subgraph.vega.internal.ui.http.requestlogviewer.FilterTask;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;

public class RequestViewContentProvider
implements ILazyContentProvider,
IRequestLogNewRecordListener {
    private final String conditionSetId;
    private final Color activeFilterColor;
    private final IEventHandler conditionSetListener;
    private IModel model;
    private IWorkspace currentWorkspace;
    private IEventHandler workspaceListener;
    private TableViewer tableViewer;
    private IHttpConditionSet filterCondition;
    private FilterTask currentResult;

    public RequestViewContentProvider(String string, Color color) {
        this.conditionSetId = string != null ? "filter." + string : "filter";
        this.conditionSetListener = this.createConditionSetListener();
        this.workspaceListener = this.createWorkspaceListener();
        this.activeFilterColor = color;
    }

    public IHttpConditionSet getConditionSet() {
        return this.filterCondition;
    }

    public void dispose() {
        this.cleanupListeners();
        this.activeFilterColor.dispose();
        if (this.currentResult != null) {
            this.currentResult.cancel();
            this.currentResult = null;
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (!(viewer instanceof TableViewer)) {
            this.tableViewer = null;
            return;
        }
        this.tableViewer = (TableViewer)viewer;
        if (object2 instanceof IModel) {
            this.setNewInput((IModel)object2);
        } else {
            this.setNullInput();
        }
    }

    private void setNullInput() {
        this.cleanupListeners();
        this.tableViewer.setItemCount(0);
        this.model = null;
        this.currentWorkspace = null;
        this.filterCondition = null;
    }

    private void setNewInput(IModel iModel) {
        this.model = iModel;
        if (iModel == null) {
            this.setNullInput();
            return;
        }
        this.filterCondition = iModel.addConditionSetTracker(this.conditionSetId, this.conditionSetListener);
        this.filterCondition.setMatchOnEmptySet(true);
        this.currentWorkspace = iModel.addWorkspaceListener(this.workspaceListener);
        if (this.currentWorkspace != null) {
            this.currentWorkspace.getRequestLog().addNewRecordListener((IRequestLogNewRecordListener)this, this.filterCondition);
        }
        this.reloadRecords();
    }

    private void cleanupListeners() {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.getRequestLog().removeNewRecordListener((IRequestLogNewRecordListener)this);
        }
        if (this.model != null) {
            if (this.filterCondition != null) {
                this.model.removeConditionSetTracker(this.conditionSetId, this.conditionSetListener);
                this.filterCondition = null;
            }
            this.model.removeWorkspaceListener(this.workspaceListener);
        }
    }

    public void updateElement(int n) {
        if (this.currentResult == null) {
            return;
        }
        IRequestLogRecord iRequestLogRecord = this.currentResult.getRecordForIndex(n);
        if (iRequestLogRecord != null) {
            this.tableViewer.replace((Object)iRequestLogRecord, n);
        }
    }

    private IEventHandler createConditionSetListener() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof ConditionSetChanged) {
                    IHttpConditionSet iHttpConditionSet = ((ConditionSetChanged)iEvent).getConditionSet();
                    RequestViewContentProvider.this.setConditionFilter(iHttpConditionSet);
                }
            }
        };
    }

    private IEventHandler createWorkspaceListener() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    RequestViewContentProvider.this.onWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    RequestViewContentProvider.this.onWorkspaceReset((WorkspaceResetEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    RequestViewContentProvider.this.onWorkspaceClose((WorkspaceCloseEvent)iEvent);
                }
                RequestViewContentProvider.this.reloadRecords();
            }
        };
    }

    private void onWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.currentWorkspace.getRequestLog().removeNewRecordListener((IRequestLogNewRecordListener)this);
        this.currentWorkspace = workspaceOpenEvent.getWorkspace();
        this.currentWorkspace.getRequestLog().addNewRecordListener((IRequestLogNewRecordListener)this, this.filterCondition);
    }

    private void onWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.currentWorkspace.getRequestLog().removeNewRecordListener((IRequestLogNewRecordListener)this);
        this.currentWorkspace = workspaceResetEvent.getWorkspace();
        this.currentWorkspace.getRequestLog().addNewRecordListener((IRequestLogNewRecordListener)this, this.filterCondition);
    }

    private void onWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.currentWorkspace.getRequestLog().removeNewRecordListener((IRequestLogNewRecordListener)this);
    }

    private void setConditionFilter(IHttpConditionSet iHttpConditionSet) {
        if (iHttpConditionSet != null) {
            iHttpConditionSet.setMatchOnEmptySet(true);
        }
        this.highlightTableForConditionFilter(iHttpConditionSet);
        IRequestLog iRequestLog = this.currentWorkspace.getRequestLog();
        this.filterCondition = iHttpConditionSet;
        iRequestLog.removeNewRecordListener((IRequestLogNewRecordListener)this);
        iRequestLog.addNewRecordListener((IRequestLogNewRecordListener)this, iHttpConditionSet);
        this.reloadRecords();
    }

    private void highlightTableForConditionFilter(IHttpConditionSet iHttpConditionSet) {
        if (iHttpConditionSet != null && iHttpConditionSet.hasActiveConditions(false)) {
            this.tableViewer.getTable().setBackground(this.activeFilterColor);
        } else {
            this.tableViewer.getTable().setBackground(null);
        }
    }

    private void reloadRecords() {
        if (this.currentResult != null) {
            this.currentResult.cancel();
        }
        if (this.currentWorkspace == null) {
            return;
        }
        this.currentResult = new FilterTask(this.tableViewer, this.currentWorkspace.getRequestLog(), this.filterCondition);
        this.currentResult.applyFilter();
    }

    public void onNewRecord(RequestLogNewRecordEvent requestLogNewRecordEvent) {
        if (this.currentResult != null) {
            this.currentResult.addNewRecord(requestLogNewRecordEvent.getNewRecord());
        }
    }

    public int getRowForRecord(IRequestLogRecord iRequestLogRecord) {
        if (this.currentResult != null) {
            return this.currentResult.getRowForRecord(iRequestLogRecord);
        }
        return -1;
    }
}

