/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.ui.http;

import com.subgraph.vega.api.http.proxy.IHttpInterceptor;
import com.subgraph.vega.api.http.proxy.IHttpInterceptorEventHandler;
import com.subgraph.vega.api.http.proxy.IHttpProxyListener;
import com.subgraph.vega.api.http.proxy.IHttpProxyService;
import com.subgraph.vega.api.http.proxy.IHttpProxyServiceEventHandler;
import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.internal.ui.http.ProxyStatusLineContribution;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ProxyServiceTrackerCustomizer
implements ServiceTrackerCustomizer<IHttpProxyService, IHttpProxyService> {
    private final BundleContext context;
    private final ProxyStatusLineContribution statusLineContribution;
    private IHttpProxyService proxyService;
    private IHttpProxyServiceEventHandler proxyEventHandler;
    private IHttpInterceptor interceptor;
    private IHttpInterceptorEventHandler interceptorEventHandler;

    public ProxyServiceTrackerCustomizer(BundleContext bundleContext, ProxyStatusLineContribution proxyStatusLineContribution) {
        this.context = bundleContext;
        this.statusLineContribution = proxyStatusLineContribution;
        this.proxyEventHandler = new IHttpProxyServiceEventHandler(){

            public void notifyStart(int n) {
                ProxyServiceTrackerCustomizer.this.handleNotifyStart(n);
            }

            public void notifyStartListener(IHttpProxyListener iHttpProxyListener) {
            }

            public void notifyStop() {
                ProxyServiceTrackerCustomizer.this.handleNotifyStop();
            }

            public void notifyStopListener(IHttpProxyListener iHttpProxyListener) {
            }

            public void notifyConfigChange(int n) {
                ProxyServiceTrackerCustomizer.this.handleNotifyConfigChange(n);
            }
        };
        this.interceptorEventHandler = new IHttpInterceptorEventHandler(){

            public void notifyQueue(IProxyTransaction iProxyTransaction, int n) {
                ProxyServiceTrackerCustomizer.this.handleNotifyQueue(iProxyTransaction);
            }

            public void notifyRemove(int n) {
                ProxyServiceTrackerCustomizer.this.handleNotifyRemove();
            }

            public void notifyEmpty() {
                ProxyServiceTrackerCustomizer.this.handleNotifyEmpty();
            }
        };
    }

    public IHttpProxyService addingService(ServiceReference<IHttpProxyService> serviceReference) {
        this.proxyService = (IHttpProxyService)this.context.getService(serviceReference);
        this.proxyService.registerEventHandler(this.proxyEventHandler);
        if (this.proxyService.isRunning()) {
            this.statusLineContribution.setProxyRunning(this.proxyService.getListenerConfigsCount());
        } else {
            this.statusLineContribution.setProxyStopped();
        }
        this.interceptor = this.proxyService.getInterceptor();
        this.interceptor.addEventHandler(this.interceptorEventHandler);
        return this.proxyService;
    }

    public void modifiedService(ServiceReference<IHttpProxyService> serviceReference, IHttpProxyService iHttpProxyService) {
    }

    public void removedService(ServiceReference<IHttpProxyService> serviceReference, IHttpProxyService iHttpProxyService) {
    }

    private void handleNotifyStart(int n) {
        this.statusLineContribution.setProxyRunning(n);
    }

    private void handleNotifyStop() {
        this.statusLineContribution.setProxyStopped();
    }

    private void handleNotifyConfigChange(int n) {
        if (this.proxyService.isRunning()) {
            this.statusLineContribution.setProxyRunning(n);
        } else {
            this.statusLineContribution.setProxyStopped();
        }
    }

    private void handleNotifyQueue(IProxyTransaction iProxyTransaction) {
        this.statusLineContribution.setProxyPending(this.interceptor.transactionQueueSize());
    }

    private void handleNotifyRemove() {
        this.statusLineContribution.setProxyPending(this.interceptor.transactionQueueSize());
    }

    private void handleNotifyEmpty() {
        this.statusLineContribution.setProxyPending(0);
    }
}

