/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy.ssl;

import com.subgraph.vega.internal.http.proxy.ssl.CertificateCreator;
import com.subgraph.vega.internal.http.proxy.ssl.CertificateStore;
import com.subgraph.vega.internal.http.proxy.ssl.HostCertificateData;
import com.subgraph.vega.internal.http.proxy.ssl.ProxySSLInitializationException;
import com.subgraph.vega.internal.http.proxy.ssl.VegaX509KeyManager;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;

public class SSLContextRepository {
    private static final Logger logger = Logger.getLogger("proxy");
    private final File storeDirectory;
    private final Map<String, SSLContext> contextMap;
    private final CertificateCreator certificateCreator;
    private CertificateStore certificateStore;

    public static SSLContextRepository createInstance(File file) throws ProxySSLInitializationException {
        return new SSLContextRepository(file);
    }

    public String getCaCertificatePem() {
        return this.certificateCreator.getCaCertificatePem();
    }

    public synchronized SSLContext getContextForName(String string) {
        if (this.contextMap.containsKey(string)) {
            return this.contextMap.get(string);
        }
        try {
            SSLContext sSLContext = this.createContextForName(string);
            this.contextMap.put(string, sSLContext);
            return sSLContext;
        }
        catch (GeneralSecurityException generalSecurityException) {
            logger.log(Level.WARNING, "Could not create security context for SSL connection", generalSecurityException);
            return null;
        }
    }

    private SSLContextRepository(File file) throws ProxySSLInitializationException {
        this.storeDirectory = file;
        this.contextMap = new HashMap<String, SSLContext>();
        this.certificateCreator = this.createCertificateCreator();
    }

    private CertificateCreator createCertificateCreator() throws ProxySSLInitializationException {
        try {
            this.certificateStore = new CertificateStore(this.storeDirectory, "foo");
            return new CertificateCreator(this.certificateStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProxySSLInitializationException("Failed to create certificate creator: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        catch (IOException iOException) {
            throw new ProxySSLInitializationException("I/O error creating certificate creator: " + iOException.getMessage(), iOException);
        }
    }

    private SSLContext createContextForName(String string) throws GeneralSecurityException {
        HostCertificateData hostCertificateData = this.certificateCreator.createCertificateDataFor(string);
        VegaX509KeyManager vegaX509KeyManager = new VegaX509KeyManager(hostCertificateData);
        SSLContext sSLContext = SSLContext.getInstance("SSLv3");
        sSLContext.init(new KeyManager[]{vegaX509KeyManager}, null, null);
        return sSLContext;
    }
}

