/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy.ssl;

import com.subgraph.vega.internal.http.proxy.ssl.CertificateSigner;
import com.subgraph.vega.internal.http.proxy.ssl.CertificateStore;
import com.subgraph.vega.internal.http.proxy.ssl.HostCertificateData;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.NetscapeCertTypeExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class CertificateCreator {
    private static final String CA_SUBJECT_NAME = "cn=Vega Proxy Certificate Authority,ou=Vega Web Vulnerability Scanner,o=Subgraph,l=Montreal,st=Quebec,c=CA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final long DEFAULT_VALIDITY = 157680000000L;
    private final CertificateStore certificateStore;
    private final KeyPairGenerator keyGenerator;
    private final Set<BigInteger> serials = new HashSet<BigInteger>();
    private final X500Principal caSubject;
    private KeyPair fixedKeyPair;
    private PrivateKey caPrivateKey;
    private PublicKey caPublicKey;
    private X509Certificate caCertificate;
    private String caPemCertificate;
    private boolean useFixedKeys = false;
    private boolean useSelfSigned = false;

    public CertificateCreator(CertificateStore certificateStore) throws CertificateException, IOException {
        this.certificateStore = certificateStore;
        this.keyGenerator = this.createKeyGenerator();
        this.caSubject = new X500Principal(CA_SUBJECT_NAME);
        this.initialize();
    }

    private void initialize() throws IOException, CertificateException {
        if (this.certificateStore.containsCaCertificate()) {
            this.caCertificate = this.certificateStore.getCaCertificate();
            this.caPrivateKey = this.certificateStore.getCaPrivateKey();
            this.caPublicKey = this.caCertificate.getPublicKey();
            this.caPemCertificate = this.createPemCertificate(this.caCertificate);
            return;
        }
        KeyPair keyPair = this.keyGenerator.generateKeyPair();
        this.caPublicKey = keyPair.getPublic();
        this.caPrivateKey = keyPair.getPrivate();
        this.caCertificate = this.generateCertificate(this.caSubject, keyPair.getPublic(), this.caSubject, this.caPublicKey, this.caPrivateKey, true);
        this.certificateStore.saveCaCertificate(this.caCertificate, this.caPrivateKey);
        this.caPemCertificate = this.createPemCertificate(this.caCertificate);
    }

    private String createPemCertificate(X509Certificate x509Certificate) throws CertificateException {
        StringBuilder stringBuilder = new StringBuilder();
        Base64 base64 = new Base64(64);
        stringBuilder.append("-----BEGIN CERTIFICATE-----\r\n");
        stringBuilder.append(base64.encodeToString(x509Certificate.getEncoded()));
        stringBuilder.append("-----END CERTIFICATE-----\r\n");
        return stringBuilder.toString();
    }

    private KeyPairGenerator createKeyGenerator() throws CertificateException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            return keyPairGenerator;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException("Failed to create RSA key pair generator." + noSuchAlgorithmException.getMessage());
        }
    }

    public String getCaCertificatePem() {
        return this.caPemCertificate;
    }

    public HostCertificateData createCertificateDataFor(String string) throws CertificateException {
        X500Principal x500Principal = this.getSubjectForCommonName(string);
        KeyPair keyPair = this.getKeyPairForNewCertificate();
        if (this.useSelfSigned) {
            return this.createSelfSignedCertificateDataFor(x500Principal, keyPair);
        }
        return this.createCaSignedCertificateDataFor(x500Principal, keyPair);
    }

    private HostCertificateData createCaSignedCertificateDataFor(X500Principal x500Principal, KeyPair keyPair) throws CertificateException {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{this.generateCertificate(x500Principal, keyPair.getPublic(), this.caSubject, this.caPublicKey, this.caPrivateKey, false), this.caCertificate};
        return new HostCertificateData(x500Principal.getName(), keyPair.getPrivate(), x509CertificateArray);
    }

    private HostCertificateData createSelfSignedCertificateDataFor(X500Principal x500Principal, KeyPair keyPair) throws CertificateException {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{this.generateCertificate(x500Principal, keyPair.getPublic(), x500Principal, keyPair.getPublic(), keyPair.getPrivate(), false)};
        return new HostCertificateData(x500Principal.getName(), keyPair.getPrivate(), x509CertificateArray);
    }

    private KeyPair getKeyPairForNewCertificate() {
        if (this.useFixedKeys) {
            return this.getFixedKeyPair();
        }
        return this.keyGenerator.generateKeyPair();
    }

    private synchronized KeyPair getFixedKeyPair() {
        if (this.fixedKeyPair == null) {
            this.fixedKeyPair = this.keyGenerator.generateKeyPair();
        }
        return this.fixedKeyPair;
    }

    private X500Principal getSubjectForCommonName(String string) {
        return new X500Principal("cn=" + string + ",ou=Vega Generated Certificate,o=Subgraph");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger getNextSerialNumber() {
        BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
        Set<BigInteger> set = this.serials;
        synchronized (set) {
            while (this.serials.contains(bigInteger)) {
                bigInteger = bigInteger.add(BigInteger.ONE);
            }
            this.serials.add(bigInteger);
            return bigInteger;
        }
    }

    private X509Certificate generateCertificate(X500Principal x500Principal, PublicKey publicKey, X500Principal x500Principal2, PublicKey publicKey2, PrivateKey privateKey, boolean bl) throws CertificateException {
        try {
            Date date = new Date();
            Date date2 = new Date(date.getTime() + 157680000000L);
            CertificateSigner certificateSigner = this.createCertificateSigner(x500Principal2, privateKey);
            CertificateValidity certificateValidity = new CertificateValidity(date, date2);
            X509CertInfo x509CertInfo = this.createCertificateInfo(x500Principal, publicKey, x500Principal2, publicKey2, certificateValidity, certificateSigner);
            CertificateExtensions certificateExtensions = bl ? CertificateCreator.getCACertificateExtensions() : CertificateCreator.getCertificateExtensions(publicKey, publicKey2);
            x509CertInfo.set("extensions", certificateExtensions);
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(privateKey, SIGNATURE_ALGORITHM);
            return x509CertImpl;
        }
        catch (Exception exception) {
            throw new CertificateException("Failed to generate certificate: " + exception.getMessage(), exception);
        }
    }

    private CertificateSigner createCertificateSigner(X500Principal x500Principal, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        X500Name x500Name = new X500Name(x500Principal.getName());
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        return new CertificateSigner(signature, x500Name);
    }

    private X509CertInfo createCertificateInfo(X500Principal x500Principal, PublicKey publicKey, X500Principal x500Principal2, PublicKey publicKey2, CertificateValidity certificateValidity, CertificateSigner certificateSigner) throws IOException, GeneralSecurityException {
        BigInteger bigInteger = this.getNextSerialNumber();
        X500Name x500Name = new X500Name(x500Principal.getName());
        X509CertInfo x509CertInfo = new X509CertInfo();
        double d = this.javaVersionAsFloat();
        x509CertInfo.set("version", new CertificateVersion(2));
        x509CertInfo.set("serialNumber", new CertificateSerialNumber(bigInteger));
        AlgorithmId algorithmId = certificateSigner.getAlgorithmId();
        x509CertInfo.set("algorithmID", new CertificateAlgorithmId(algorithmId));
        if (d >= 1.8) {
            x509CertInfo.set("subject", x500Name);
            x509CertInfo.set("issuer", certificateSigner.getSigner());
        } else {
            x509CertInfo.set("issuer", new CertificateIssuerName(certificateSigner.getSigner()));
            x509CertInfo.set("subject", new CertificateSubjectName(x500Name));
        }
        x509CertInfo.set("key", new CertificateX509Key(publicKey));
        x509CertInfo.set("validity", certificateValidity);
        return x509CertInfo;
    }

    private double javaVersionAsFloat() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        String string = System.getProperty("java.version");
        while (n2 < string.length() && n < 2) {
            if (string.charAt(n2) == '.') {
                ++n;
            }
            ++n2;
        }
        d = Double.parseDouble(string.substring(0, --n2));
        return d;
    }

    private static CertificateExtensions getCACertificateExtensions() throws IOException {
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        certificateExtensions.set("BasicConstraints", new BasicConstraintsExtension(true, true, 0));
        return certificateExtensions;
    }

    private static CertificateExtensions getCertificateExtensions(PublicKey publicKey, PublicKey publicKey2) throws IOException {
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        certificateExtensions.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(new KeyIdentifier(publicKey).getIdentifier()));
        certificateExtensions.set("AuthorityKeyIdentifier", new AuthorityKeyIdentifierExtension(new KeyIdentifier(publicKey2), null, null));
        certificateExtensions.set("BasicConstraints", new BasicConstraintsExtension(true, false, 5));
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(blArray);
        netscapeCertTypeExtension = new NetscapeCertTypeExtension(false, netscapeCertTypeExtension.getExtensionValue());
        certificateExtensions.set("NetscapeCertType", netscapeCertTypeExtension);
        boolean[] blArray2 = new boolean[9];
        blArray2[0] = true;
        blArray2[2] = true;
        KeyUsageExtension keyUsageExtension = new KeyUsageExtension(blArray2);
        certificateExtensions.set("KeyUsage", keyUsageExtension);
        int[] nArray = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        int[] nArray2 = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 2};
        ObjectIdentifier objectIdentifier2 = new ObjectIdentifier(nArray2);
        Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>();
        vector.add(objectIdentifier);
        vector.add(objectIdentifier2);
        ExtendedKeyUsageExtension extendedKeyUsageExtension = new ExtendedKeyUsageExtension((Boolean)false, vector);
        certificateExtensions.set("ExtendedKeyUsage", extendedKeyUsageExtension);
        return certificateExtensions;
    }
}

