/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.internal.http.proxy.VegaHttpRequestFactory;
import com.subgraph.vega.internal.http.proxy.VegaHttpRequestParser;
import java.io.IOException;
import java.net.Socket;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.impl.SocketHttpServerConnection;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class VegaHttpServerConnection
extends SocketHttpServerConnection {
    private HttpRequest cachedRequest;
    private final HttpParams params;
    private HttpHost sslHost;

    public VegaHttpServerConnection(HttpParams httpParams) {
        this.params = httpParams;
    }

    protected HttpRequestFactory createHttpRequestFactory() {
        return new VegaHttpRequestFactory();
    }

    protected HttpMessageParser<HttpRequest> createRequestParser(SessionInputBuffer sessionInputBuffer, HttpRequestFactory httpRequestFactory, HttpParams httpParams) {
        return new VegaHttpRequestParser(this, sessionInputBuffer, (LineParser)new BasicLineParser(), httpRequestFactory, httpParams);
    }

    public boolean isSslConnection() {
        return this.sslHost != null;
    }

    public HttpHost getSslHost() {
        return this.sslHost;
    }

    public void rebindWithSSL(Socket socket, HttpHost httpHost) throws IOException {
        this.sslHost = new HttpHost(httpHost);
        this.bind(socket, this.params);
    }

    public void bind(Socket socket, HttpParams httpParams) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)httpParams));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)httpParams));
        int n = HttpConnectionParams.getLinger((HttpParams)httpParams);
        if (n >= 0) {
            socket.setSoLinger(n > 0, n);
        }
        super.bind(socket, httpParams);
    }

    HttpRequest peekRequestHeader() throws HttpException, IOException {
        if (this.cachedRequest != null) {
            throw new IllegalStateException("A cached peeked request already exists");
        }
        this.cachedRequest = super.receiveRequestHeader();
        return this.cachedRequest;
    }

    void dropCachedPeekRequest() {
        if (this.cachedRequest == null) {
            throw new IllegalStateException("Cannot drop cached peek request, because no request is cached.");
        }
        this.cachedRequest = null;
    }

    public HttpRequest receiveRequestHeader() throws HttpException, IOException {
        if (this.cachedRequest != null) {
            HttpRequest httpRequest = this.cachedRequest;
            this.cachedRequest = null;
            return httpRequest;
        }
        return super.receiveRequestHeader();
    }

    public Socket getSocket() {
        return super.getSocket();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.isOpen()) {
            stringBuffer.append(this.getRemotePort());
        } else {
            stringBuffer.append("closed");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

