/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.api.http.proxy.IHttpProxyTransactionManipulator;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class ProxyTransactionManipulator
implements IHttpProxyTransactionManipulator {
    private static final String[] CONDITIONAL_REQUEST_HEADERS = new String[]{"If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since"};
    private String userAgent;
    private boolean userAgentOverride;
    private boolean disableBrowserCache;
    private boolean disableProxyCache;

    public synchronized void setUserAgent(String string) {
        this.userAgent = string;
    }

    public synchronized void setUserAgentOverride(boolean bl) {
        this.userAgentOverride = bl;
    }

    public synchronized void setBrowserCacheDisable(boolean bl) {
        this.disableBrowserCache = bl;
    }

    public synchronized void setProxyCacheDisable(boolean bl) {
        this.disableProxyCache = bl;
    }

    public synchronized void process(HttpRequest httpRequest) {
        if (this.userAgent != null) {
            if (this.userAgentOverride) {
                httpRequest.setHeader((Header)new BasicHeader("User-Agent", this.userAgent));
            } else {
                HttpProtocolParams.setUserAgent((HttpParams)httpRequest.getParams(), (String)this.userAgent);
            }
        }
        if (this.disableBrowserCache) {
            String[] stringArray = CONDITIONAL_REQUEST_HEADERS;
            int n = CONDITIONAL_REQUEST_HEADERS.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                httpRequest.removeHeaders(string);
                ++n2;
            }
        }
        if (this.disableProxyCache) {
            httpRequest.setHeader((Header)new BasicHeader("Cache-Control", "no-cache"));
            httpRequest.setHeader((Header)new BasicHeader("Pragma", "no-cache"));
        }
    }

    public synchronized void process(HttpResponse httpResponse) {
    }
}

