/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.scope.ActiveScopeChangedEvent;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.internal.http.proxy.ProxyScanner;

public class ProxyScannerScopeTracker {
    private final IEventHandler scopeChangeHandler;
    private final ProxyScanner proxyScanner;
    private IWorkspace currentWorkspace;
    private ITargetScope currentActiveScope;

    ProxyScannerScopeTracker(IModel iModel, ProxyScanner proxyScanner) {
        this.proxyScanner = proxyScanner;
        this.scopeChangeHandler = this.createScopeChangeListener();
        this.setCurrentWorkspace(iModel.addWorkspaceListener(this.createWorkspaceListener()));
    }

    ITargetScope getCurrentActiveScope() {
        return this.currentActiveScope;
    }

    private IEventHandler createWorkspaceListener() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    ProxyScannerScopeTracker.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    ProxyScannerScopeTracker.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    ProxyScannerScopeTracker.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        };
    }

    private IEventHandler createScopeChangeListener() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof ActiveScopeChangedEvent) {
                    ProxyScannerScopeTracker.this.currentActiveScope = ((ActiveScopeChangedEvent)iEvent).getActiveScope();
                }
            }
        };
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.setCurrentWorkspace(workspaceOpenEvent.getWorkspace());
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.setCurrentWorkspace(workspaceResetEvent.getWorkspace());
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.setCurrentWorkspace(null);
    }

    private void setCurrentWorkspace(IWorkspace iWorkspace) {
        IWorkspace iWorkspace2 = this.currentWorkspace;
        this.currentWorkspace = iWorkspace;
        this.currentActiveScope = this.setScopeChangeListener(iWorkspace2, iWorkspace);
        this.proxyScanner.handleWorkspaceChanged(iWorkspace);
    }

    private ITargetScope setScopeChangeListener(IWorkspace iWorkspace, IWorkspace iWorkspace2) {
        if (iWorkspace != null) {
            iWorkspace.getTargetScopeManager().removeActiveScopeChangeListener(this.scopeChangeHandler);
        }
        if (iWorkspace2 != null) {
            return iWorkspace2.getTargetScopeManager().addActiveScopeChangeListener(this.scopeChangeHandler);
        }
        return null;
    }
}

