/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.scope.ITargetScope;
import com.subgraph.vega.api.scanner.IProxyScan;
import com.subgraph.vega.api.scanner.IScanner;
import com.subgraph.vega.api.scanner.IScannerConfig;
import com.subgraph.vega.api.scanner.modules.IBasicModuleScript;
import com.subgraph.vega.api.util.VegaURI;
import com.subgraph.vega.internal.http.proxy.HttpProxyService;
import com.subgraph.vega.internal.http.proxy.ProxyScannerScopeTracker;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;

public class ProxyScanner {
    private final Logger logger = Logger.getLogger(HttpProxyService.class.getName());
    private final IScanner scanner;
    private final CookieStore cookieStore;
    private final ProxyScannerScopeTracker scopeTracker;
    private IProxyScan proxyScan;
    private boolean isEnabled = false;

    ProxyScanner(IScanner iScanner, CookieStore cookieStore, IModel iModel) {
        this.scanner = iScanner;
        this.cookieStore = cookieStore;
        this.scopeTracker = new ProxyScannerScopeTracker(iModel, this);
    }

    void reloadModules() {
        if (this.proxyScan != null) {
            this.proxyScan.reloadModules();
        }
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    void setEnabled(boolean bl) {
        this.reloadModules();
        this.isEnabled = bl;
    }

    List<IBasicModuleScript> getInjectionModules() {
        if (this.proxyScan == null) {
            return Collections.emptyList();
        }
        return this.proxyScan.getInjectionModules();
    }

    IScannerConfig getConfig() {
        if (this.proxyScan == null) {
            return null;
        }
        return this.proxyScan.getConfig();
    }

    void processRequest(HttpUriRequest httpUriRequest) {
        if (this.proxyScan == null) {
            throw new IllegalStateException("Cannot process request because no proxy scan is currently active");
        }
        if (httpUriRequest.getMethod().equalsIgnoreCase("GET")) {
            this.handleProxyScanGetRequest(httpUriRequest);
        } else if (httpUriRequest.getMethod().equalsIgnoreCase("POST")) {
            this.handleProxyScanPostRequest(httpUriRequest);
        }
    }

    void handleWorkspaceChanged(IWorkspace iWorkspace) {
        if (this.proxyScan != null) {
            this.proxyScan.stop();
        }
        this.isEnabled = false;
        if (iWorkspace != null) {
            this.proxyScan = this.scanner.createProxyScan(iWorkspace, this.cookieStore);
        }
    }

    private void handleProxyScanGetRequest(HttpUriRequest httpUriRequest) {
        List list = URLEncodedUtils.parse((URI)httpUriRequest.getURI(), (String)"UTF-8");
        if (list.isEmpty()) {
            return;
        }
        URI uRI = httpUriRequest.getURI();
        if (this.isTargetInScope(uRI)) {
            this.proxyScan.scanGetTarget(this.requestToURI(httpUriRequest), list);
        }
    }

    private void handleProxyScanPostRequest(HttpUriRequest httpUriRequest) {
        List list;
        if (!(httpUriRequest instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpUriRequest).getEntity();
        try {
            list = URLEncodedUtils.parse((HttpEntity)httpEntity);
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Exception reading request entity", iOException);
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        URI uRI = httpUriRequest.getURI();
        if (this.isTargetInScope(uRI)) {
            this.proxyScan.scanPostTarget(this.requestToURI(httpUriRequest), list);
        }
    }

    private VegaURI requestToURI(HttpUriRequest httpUriRequest) {
        URI uRI = httpUriRequest.getURI();
        HttpHost httpHost = URIUtils.extractHost((URI)uRI);
        return new VegaURI(httpHost, uRI.getPath(), uRI.getQuery());
    }

    private boolean isTargetInScope(URI uRI) {
        ITargetScope iTargetScope = this.scopeTracker.getCurrentActiveScope();
        if (iTargetScope == null) {
            return false;
        }
        return iTargetScope.filter(uRI);
    }
}

